;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;								;
; Copyright (c) 2001-2023 Fidelity National Information		;
; Services, Inc. and/or its subsidiaries. All rights reserved.	;
;								;
;	This source code contains the intellectual property	;
;	of its copyright holder(s), and is made available	;
;	under a license.  If you do not know the terms of	;
;	the license, please stop and do not read further.	;
;								;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
%gbldef	; ; ;Global Collation Control
	;
kill(gname)
	new $ETRAP,blkidlen
	set $ETRAP="goto error"
	if $TLEVEL zmessage 150383202	; TPNOSUPPORT error
	if '$$edit(.gname) quit 0
	if $zfind($view("REGION",gname),",") zmessage 150383194:gname	; ISSPANGBL
	if "BGMM"'[$view("GVACCESS_METHOD",$view("REGION",gname)) do
	. zmessage 150376418:$view("REGION",gname) ; DBREMOTE
	if $data(@gname) zmessage 150373626	; Error if there is data in the global
	set @gname="" kill @gname		; make sure that the global has a root
	set blkidlen=$$getblkidlen(gname)
	set gname=$zextract(gname,2,32)		; remove circumflex, take at most 31 chars
	view "YDIRTVAL":$zextract($view("YDIRTREE",gname),1,blkidlen),"YDIRTREE":gname
	quit 1
	;
set(gname,nct,act)
	new $ETRAP,blkidlen,ver
	set $ETRAP="goto error"
	if $TLEVEL zmessage 150383202	; TPNOSUPPORT error
	if '$$edit(.gname) q 0
	if $zfind($view("REGION",gname),",") zmessage 150383194:gname	; ISSPANGBL error
	if "BGMM"'[$view("GVACCESS_METHOD",$view("REGION",gname)) do
	. zmessage 150376418:$view("REGION",gname) ; DBREMOTE error
	if $data(@gname) zmessage 150373626 		; Error if there is data in the global
	set act=+$g(act),nct=+$g(nct) set:nct nct=1
	if (act>255)!(act<0) zmessage 150374290:act	; collation type specified is illegal
	set ver=$view("YCOLLATE",act)
	if ver<0 zmessage 150376282:act		; doesn't find coll type, or can't get version
	set @gname="" kill @gname			; make sure that the global has a root
	set blkidlen=$$getblkidlen(gname)
	set gname=$zextract(gname,2,32)			; remove circumflex, take at most 31 chars
	view "YDIRTVAL":$zextract($view("YDIRTREE",gname),1,blkidlen)_$zchar(1,nct,act,ver),"YDIRTREE":gname
	quit 1
	;
get(gname,reg)
	new t,tl,$ETRAP,nct,act,ver,ret,dir,dl,error,label,blkidend
	set $ETRAP="goto error"
	if '$$edit(.gname) quit 0
	set:$get(reg)="" reg=$piece($view("REGION",gname),",",1)
	set label=$extract($$^%PEEKBYNAME("sgmnt_data.label",reg),1,11)
	set blkidend=$select(label="GDSDYNUNX03":5,1:9) ; if DB is V6 use 4 byte length else use 8
	set gname=$zextract(gname,2,32)
	if "BGMM"'[$view("GVACCESS_METHOD",reg) zmessage 150376418:reg ; DBREMOTE
	; -----------------------------------
	; first check in directory tree
	set dir=$view("YDIRTREE",gname,reg),dl=$zlength(dir)
	; the next line only works for V7 DBs and will need to be modified to work with V6 as well
	set t=$zextract(dir,blkidend,999),tl=$zlength(t)	; remove circumflex, take at most 31 chars
	if tl,(tl'=4)!($ascii(t,1)'=1) zmessage 150374058
	if tl set nct=$ascii(t,2),act=$ascii(t,3),ver=$ascii(t,4) quit nct_","_act_","_ver
	; -----------------------------------
	; db directory tree has no collation information. next check for gld.
	set t=$view("YGLDCOLL","^"_gname)
	if t'="0" set nct=$piece(t,",",1),act=$piece(t,",",2),ver=$piece(t,",",3)  quit nct_","_act_","_ver
	; -----------------------------------
	; no collation information was found in gld. check for coll info from db file hdr
	set nct=0 do  quit:(act=0) 0
	. do getzpeek("sgmnt_data.def_coll",reg,.act)
	. do getzpeek("sgmnt_data.def_coll_ver",reg,.ver)
	quit nct_","_act_","_ver
	;
getblkidlen(gname)
	new blkver,reg
	; V7m/V7 use 8, prior vers use 4 bytes. WARNING: This is true in the directory tree only
	set reg=$view("REGION",gname),blkver=$$^%PEEKBYNAME("sgmnt_data.desired_db_format",reg)
	quit $select(2>blkver:4,1:8)
	;
getzpeek(field,region,result)
	new xstr
	set result=$$^%PEEKBYNAME(field,region)
	quit
edit(gname)
	if $zextract(gname)'="^" set gname="^"_gname
	if $zextract(gname,2)'="%",$zextract(gname,2)'?1A zmessage 150373218	; LKNAMEXPECTED
	if gname'?1"^"1E.AN zmessage 150373218
	quit 1
	;
error	set $ECODE="",error=1
	quit 0
