/*
 * Decompiled with CFR 0.152.
 */
package com.frsvision.resources.pos;

import com.frsvision.resources.pos.Error;
import com.frsvision.resources.pos.FrsvisionException;

public class Response {
    private final String code;
    private final String description;

    public Response(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static Response parse(String responseText) throws FrsvisionException {
        String description;
        String code;
        String[] parts = responseText.split(" - ");
        if (parts.length != 2) {
            throw new FrsvisionException(new Error("invalid_data", "invalid response: '" + responseText + "'"));
        }
        int index = parts[0].indexOf(32);
        if (index >= 0) {
            code = parts[0].substring(0, index);
            description = parts[0].substring(index + 1) + ' ' + parts[1];
        } else {
            code = parts[0];
            description = parts[1];
        }
        return new Response(code, description);
    }

    public static String stringify(Response response) {
        return response.code + " - " + response.description;
    }

    public Response() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

