/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.frsvision.resources.pos.Error;
import com.frsvision.resources.pos.FrsvisionException;
import com.genorder.bean.GeneralOrder;
import com.genorder.bean.OrderItem;
import com.genorder.bean.Payment;
import com.genorder.bean.PaymentCibus;
import com.openrest.resources.ConvertSoV3OrderToGeneralOrder;
import com.presto.bean.Address;
import com.presto.bean.Contact;
import com.presto.bean.CreditCard;
import com.presto.bean.Delivery;
import com.presto.bean.Order;
import com.presto.bean.OrderAddons;
import com.presto.bean.OrderAddsofAdds;
import com.presto.bean.OrderCharges;
import com.presto.bean.PrestoParams;
import com.toorder.resources.ToOrderFormatUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConvertGeneralToPrestoOrderV3
extends ConvertSoV3OrderToGeneralOrder {
    private Order prestoOrder;
    private PrestoParams prestoParams;
    private static final long prestoDealStartId = 100000L;
    private static final long prestoOptionStartId = 200000L;

    public void ConvertGenToPrestoOrder() throws UnsupportedEncodingException, FrsvisionException {
        this.prestoOrder = new Order();
        this.getPrestoOrder().setId(this.getGord().getOrder_source().getSource_order_id());
        String fname = this.getGord().getOrder_contact().get(0).getContact_firstname();
        String lname = this.getGord().getOrder_contact().get(0).getContact_lastname();
        String phone = this.getGord().getOrder_contact().get(0).getContact_phone();
        fname = ToOrderFormatUtils.unicodeToWindowsHebrew(fname);
        lname = ToOrderFormatUtils.unicodeToWindowsHebrew(lname);
        this.getPrestoOrder().setContact(new Contact());
        this.getPrestoOrder().getContact().setFirstName(fname);
        this.getPrestoOrder().getContact().setLastName(lname);
        this.getPrestoOrder().getContact().setPhone(phone);
        Address pradd = new Address();
        this.getPrestoOrder().setDelivery(new Delivery());
        if (!"TAW".equals(this.getGord().getAddress().getCity())) {
            pradd.setCity(ToOrderFormatUtils.unicodeToWindowsHebrew(this.getGord().getAddress().getCity()));
            pradd.setStreet(ToOrderFormatUtils.unicodeToWindowsHebrew(this.getGord().getAddress().getStreet()));
            pradd.setEntrance(ToOrderFormatUtils.unicodeToWindowsHebrew(this.getGord().getAddress().getEntrance()));
            pradd.setNumber(ToOrderFormatUtils.unicodeToWindowsHebrew(this.getGord().getAddress().getHouse_number()));
            pradd.setFloor(this.getGord().getAddress().getFloor_num());
            pradd.setApt(this.getGord().getAddress().getAppartment());
            pradd.setComment(ToOrderFormatUtils.unicodeToWindowsHebrew(this.getGord().getAddress().getAddress_remark()));
            pradd.setFormatted(pradd.getCity() + " , " + pradd.getStreet());
            this.getPrestoOrder().getDelivery().setAddress(pradd);
            this.getPrestoOrder().getDelivery().setCharge(Double.valueOf(this.getGord().getDelivery_fee()));
            this.getPrestoOrder().getDelivery().setType("delivery");
        } else {
            pradd.setCity("");
            pradd.setStreet("");
            pradd.setEntrance("");
            pradd.setNumber("");
            pradd.setFloor("");
            pradd.setApt("");
            pradd.setComment("");
            pradd.setFormatted("");
            this.getPrestoOrder().getDelivery().setAddress(pradd);
            this.getPrestoOrder().getDelivery().setType("takeaway");
        }
        this.getPrestoOrder().getDelivery().setNummpl(String.valueOf(this.getGord().getNum_of_dinners()));
        this.getPrestoOrder().getDelivery().setWorkercode(this.prestoParams.getWorker());
        this.getPrestoOrder().setOrderItems(new ArrayList<com.presto.bean.OrderItem>());
        this.getPrestoOrder().getOrderItems().addAll(this.getOrderItems(this.getGord()));
        this.getPrestoOrder().setComment(ToOrderFormatUtils.unicodeToWindowsHebrew(this.getGord().getOrder_remark()) + " | " + pradd.getComment());
        this.getPrestoOrder().setTakeoutPacks(0);
        this.getPrestoOrder().setOrderCharges(new ArrayList<OrderCharges>());
        OrderCharges prord_discount = new OrderCharges();
        String disc = this.getGord().getOrder_discount() == null ? "0.0" : this.getGord().getOrder_discount();
        OrderCharges prord_tip = new OrderCharges();
        String tip = this.getGord().getOrder_tip() == null ? "0.0" : this.getGord().getOrder_tip();
        prord_discount.setAmount(Double.valueOf(disc));
        prord_tip.setAmount(Double.valueOf(tip));
        this.getPrestoOrder().getOrderCharges().add(prord_discount);
        this.getPrestoOrder().setPrice(Double.valueOf(this.getGord().getOrder_total()) - Double.valueOf(tip));
        this.getPrestoOrder().setPayments(this.getOrderPayments(this.getGord(), this.prestoParams));
    }

    private ArrayList<com.presto.bean.OrderItem> getOrderItems(GeneralOrder genord) throws UnsupportedEncodingException, FrsvisionException {
        ArrayList<com.presto.bean.OrderItem> prItmList = new ArrayList<com.presto.bean.OrderItem>();
        ArrayList prItmOptList = new ArrayList();
        HashMap<com.presto.bean.OrderItem, Integer> prItemMap = new HashMap<com.presto.bean.OrderItem, Integer>();
        int i = 0;
        int j = 0;
        for (OrderItem oi : genord.getOrder_items()) {
            if (oi.getItem_pos_id().contains("0-")) {
                throw new FrsvisionException(new Error(Error.ERROR_POS_MISSING_ITEM_NUMBER, "Invalid  Pos item id " + oi.getItem_source_id() + "|" + oi.getItem_name()));
            }
            try {
                String id;
                String item_id = oi.getItem_pos_id().trim();
                if (item_id.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) continue;
                if (item_id.contains("d")) {
                    id = item_id.replaceAll("d", "");
                    item_id = String.valueOf(Long.parseLong(id) + 100000L);
                }
                if (item_id.contains("o")) {
                    id = item_id.replaceAll("o", "");
                    item_id = String.valueOf(Long.parseLong(id) + 200000L);
                }
                if (item_id == null) {
                    throw new FrsvisionException(new Error(Error.ERROR_POS_MISSING_ITEM_NUMBER, "Invalid  Pos item id " + oi.getItem_source_id() + "|" + oi.getItem_name()));
                }
                if (oi.getItem_level() > 0) {
                    OrderAddons prAdd = new OrderAddons();
                    if (Long.parseLong(item_id) < 100000L) {
                        prAdd.setType("item");
                        prAdd.setId(item_id);
                    } else if (Long.parseLong(item_id) >= 200000L) {
                        prAdd.setType("option");
                        prAdd.setId(String.valueOf(Long.parseLong(item_id) - 200000L));
                    }
                    prAdd.setComment(ToOrderFormatUtils.unicodeToWindowsHebrew(oi.getItem_comment()));
                    prAdd.setPrice(Double.valueOf(oi.getItem_price()));
                    if ("V".equals(oi.getItem_type())) {
                        ((com.presto.bean.OrderItem)prItmList.get(i)).getChildren().add(prAdd);
                        j = ((com.presto.bean.OrderItem)prItmList.get(i)).getChildren().lastIndexOf(prAdd);
                    }
                    if (!"VOV".equals(oi.getItem_type())) continue;
                    OrderAddsofAdds adOffAdd = new OrderAddsofAdds();
                    adOffAdd.setId(prAdd.getId());
                    adOffAdd.setType(prAdd.getType());
                    adOffAdd.setPrice(prAdd.getPrice());
                    adOffAdd.setComment(prAdd.getComment());
                    ((com.presto.bean.OrderItem)prItmList.get(i)).getChildren().get(j).getChildren().add(adOffAdd);
                    continue;
                }
                com.presto.bean.OrderItem prItm = new com.presto.bean.OrderItem();
                if (Long.parseLong(item_id) < 100000L) {
                    prItm.setType("item");
                    prItm.setId(item_id);
                } else if (Long.parseLong(item_id) >= 100000L && Long.parseLong(item_id) < 200000L) {
                    prItm.setType("deal");
                    prItm.setId(String.valueOf(Long.parseLong(item_id) - 100000L));
                }
                prItm.setComment(ToOrderFormatUtils.unicodeToWindowsHebrew(oi.getItem_comment()));
                prItm.setPrice(Double.valueOf(oi.getItem_price()));
                prItmList.add(prItm);
                i = prItmList.lastIndexOf(prItm);
                prItemMap.put(prItm, Integer.valueOf(oi.getItem_qty()));
            }
            catch (NumberFormatException e) {
                throw new FrsvisionException(new Error(Error.ERROR_POS_MISSING_ITEM_NUMBER, "Pos item id isn't numeric " + oi.getItem_source_id() + "|" + oi.getItem_name()));
            }
        }
        ArrayList<com.presto.bean.OrderItem> prtItmList1 = new ArrayList<com.presto.bean.OrderItem>();
        for (com.presto.bean.OrderItem oi : prItemMap.keySet()) {
            for (int ii = 1; ii <= (Integer)prItemMap.get(oi); ++ii) {
                prtItmList1.add(oi);
            }
        }
        return prtItmList1;
    }

    private List<com.presto.bean.Payment> getOrderPayments(GeneralOrder genord, PrestoParams prestoparams) {
        ArrayList<com.presto.bean.Payment> prPayList = new ArrayList<com.presto.bean.Payment>();
        com.presto.bean.Payment PostCredit = new com.presto.bean.Payment();
        if (genord.getOrder_source().getSource_id() == 4 || genord.getOrder_source().getSource_id() == 1) {
            PostCredit.setAmount(genord.getOrder_total());
            PostCredit.setCard(new CreditCard());
            PostCredit.getCard().setNumber("1");
            PostCredit.setType("costcredit");
            prPayList.add(PostCredit);
            return prPayList;
        }
        for (Payment genPay : genord.getPayments()) {
            com.presto.bean.Payment prPay = new com.presto.bean.Payment();
            if (genPay instanceof PaymentCibus) {
                prPay.setAmount(genPay.getAmount());
                prPay.getCard().setNumber(prestoparams.getCosticket());
                prPay.getCard().setExpireMonth(1);
                prPay.getCard().setExpireYear(1);
                prPay.getCard().setCsc("");
                prPay.getCard().setHolderId("");
                prPay.getCard().setHolderName("");
                prPay.setType("costcredit");
            } else if (genPay.getPayment_id() == 3) {
                prPay.setAmount(genPay.getAmount());
                if (null != prestoparams.getCrediticket()) {
                    prPay.getCard().setNumber(prestoparams.getCrediticket());
                    prPay.getCard().setExpireMonth(1);
                    prPay.getCard().setExpireYear(1);
                    prPay.getCard().setCsc("");
                    prPay.getCard().setHolderId("");
                    prPay.getCard().setHolderName("");
                    prPay.setType("costtiket");
                } else {
                    prPay.getCard().setNumber(genPay.getPayment_card_dets().getCc_number());
                    String exp_yy = "";
                    exp_yy = genPay.getPayment_card_dets().getCc_exp().substring(3);
                    prPay.getCard().setExpireYear(Integer.parseInt("20" + exp_yy));
                    prPay.getCard().setExpireMonth(Integer.parseInt(genPay.getPayment_card_dets().getCc_exp().substring(0, 2)));
                    prPay.getCard().setHolderId(genPay.getPayment_card_dets().getCc_owner_id());
                    prPay.getCard().setCsc(genPay.getPayment_card_dets().getCc_cvv());
                    prPay.setType("credit");
                }
            } else {
                prPay.setAmount(genPay.getAmount());
                prPay.setType("cash");
                prPay.setCard(new CreditCard());
            }
            prPayList.add(prPay);
        }
        return prPayList;
    }

    public Order getPrestoOrder() {
        return this.prestoOrder;
    }

    public void setPrestoOrder(Order prestoOrder) {
        this.prestoOrder = prestoOrder;
    }

    public PrestoParams getPrestoParams() {
        if (this.prestoParams == null) {
            this.prestoParams = new PrestoParams();
        }
        return this.prestoParams;
    }

    public void setPrestoParams(PrestoParams prestoParams) {
        this.prestoParams = prestoParams;
    }
}

