/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.genorder.bean.Address;
import com.genorder.bean.OrderContact;
import com.genorder.bean.OrderItem;
import com.genorder.bean.OrderLog;
import com.genorder.bean.OrderRestaurant;
import com.genorder.bean.OrderSource;
import com.genorder.bean.OrderStatus;
import com.genorder.bean.Payment;
import com.genorder.bean.PaymentCreditCardDets;
import com.genorder.bean.RestPosParams;
import com.genorder.resources.GetOrderDetailts;
import com.openrest.olo.charges.OrderCharge;
import com.openrest.olo.dispatches.DeliveryDispatch;
import com.openrest.order.beans.ItemDets;
import com.openrest.order.beans.OrderAndMenu;
import com.toorder.resources.DBConnector;
import com.toorder.resources.ToOrderFormatUtils;
import com.wix.pay.creditcard.CreditCard;
import com.wix.pay.creditcard.CreditCardOptionalFields;
import com.wix.pay.creditcard.PublicCreditCardOptionalFields;
import com.wix.restaurants.payments.CreditcardPayment;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetSoOrderDetailts
implements GetOrderDetailts<OrderAndMenu> {
    @Override
    public String getOrderId() {
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        try {
            String order_id = dbc.execute("W $$^%W1SsID(\"SeferHaOchel\")", global_map);
            return order_id;
        }
        catch (Exception ex) {
            Logger.getLogger(GetSoOrderDetailts.class.getName()).log(Level.SEVERE, null, ex);
            return "ERR-GET-ORDER-ID";
        }
    }

    @Override
    public Address getOrderAddress(OrderAndMenu om) {
        String city = "TAW";
        String neightbourhood = "";
        String street = "";
        String hous_num = "";
        String entrance = "";
        String floor = "";
        String appartment = "";
        String addr_comment = "";
        Double gps_geo_lat = 0.0;
        Double gps_geo_lng = 0.0;
        if (om.getOrder().delivery instanceof DeliveryDispatch) {
            DeliveryDispatch odlv = (DeliveryDispatch)om.getOrder().delivery;
            city = ToOrderFormatUtils.frmString(odlv.address.city);
            neightbourhood = "";
            street = ToOrderFormatUtils.frmString(odlv.address.street);
            hous_num = ToOrderFormatUtils.frmString(odlv.address.number);
            entrance = ToOrderFormatUtils.frmString(odlv.address.entrance);
            floor = ToOrderFormatUtils.frmString(odlv.address.floor);
            appartment = ToOrderFormatUtils.frmString(odlv.address.apt);
            addr_comment = ToOrderFormatUtils.frmString(odlv.address.comment);
            gps_geo_lat = odlv.address.latLng.lat;
            gps_geo_lng = odlv.address.latLng.lng;
        }
        return new Address(city, neightbourhood, street, hous_num, entrance, floor, appartment, addr_comment, gps_geo_lat, gps_geo_lng);
    }

    @Override
    public Date getOrderDateDeliveryTime(OrderAndMenu om) {
        Date order_dlv_time = om.getOrder().delivery.time;
        return order_dlv_time;
    }

    @Override
    public List<OrderContact> getOrderContacts(OrderAndMenu om) {
        String contact_firstname = ToOrderFormatUtils.frmString(om.getOrder().contact.firstName);
        String contact_lastname = ToOrderFormatUtils.frmString(om.getOrder().contact.lastName);
        String contact_phone = ToOrderFormatUtils.frmPhone(om.getOrder().contact.phone);
        String contact_cellphone = ToOrderFormatUtils.frmPhone(om.getOrder().contact.phone);
        String contact_email = ToOrderFormatUtils.frmString(om.getOrder().contact.email);
        String contact_fax = ToOrderFormatUtils.frmPhone(om.getOrder().contact.fax);
        String contact_id = "";
        OrderContact oc = new OrderContact(contact_firstname, contact_lastname, contact_phone, contact_cellphone, contact_email, contact_fax, contact_id);
        LinkedList<OrderContact> ord_contact_list = new LinkedList<OrderContact>();
        ord_contact_list.add(oc);
        return ord_contact_list;
    }

    @Override
    public List<OrderItem> getOrderItems(OrderAndMenu om) {
        LinkedList<OrderItem> gen_order_items = new LinkedList<OrderItem>();
        int item_poz = 0;
        for (com.openrest.v1_1.OrderItem oi : om.getOrder().orderItems) {
            ++item_poz;
            ItemDets iDets = new ItemDets().setItemDetails(oi, om.getMenu());
            String itemID = ToOrderFormatUtils.frmString(iDets.getItemId());
            String itemPosID = ToOrderFormatUtils.frmString(iDets.getItemPosID());
            String itemName = ToOrderFormatUtils.frmString(iDets.getItemName());
            String itemPrice = iDets.getItemPrice();
            String itemComment = ToOrderFormatUtils.frmString(iDets.getItemComment());
            String itemQty = "1.00";
            String itemDiscount = "0.00";
            String itemTotal = "0.00";
            OrderItem gen_order_item = new OrderItem(item_poz, 0, "", itemID, itemPosID, itemName, itemPrice, itemQty, itemDiscount, itemTotal, itemComment);
            gen_order_items.add(gen_order_item);
            for (List varChoices : oi.variationsChoices) {
                for (com.openrest.v1_1.OrderItem varChoice : varChoices) {
                    ItemDets varDets = new ItemDets().setItemDetails(varChoice, om.getMenu());
                    ++item_poz;
                    String varId = ToOrderFormatUtils.frmString(varDets.getItemId());
                    String varPosID = ToOrderFormatUtils.frmString(varDets.getItemPosID());
                    String varName = ToOrderFormatUtils.frmString(varDets.getItemName());
                    String varPrice = varDets.getItemPrice();
                    String varComment = ToOrderFormatUtils.frmString(varDets.getItemComment());
                    String varQty = "1.00";
                    String varDiscount = "0.00";
                    String varTotal = "0.00";
                    OrderItem gen_order_var = new OrderItem(item_poz, 1, "V", varId, varPosID, varName, varPrice, varQty, varDiscount, varTotal, varComment);
                    gen_order_items.add(gen_order_var);
                    for (List varOfvarChoices : varChoice.variationsChoices) {
                        for (com.openrest.v1_1.OrderItem varOfvarChoice : varOfvarChoices) {
                            ItemDets varOfvarDets = new ItemDets().setItemDetails(varOfvarChoice, om.getMenu());
                            ++item_poz;
                            String varOfvarId = ToOrderFormatUtils.frmString(varOfvarDets.getItemId());
                            String varOfvarPosID = ToOrderFormatUtils.frmString(varOfvarDets.getItemPosID());
                            String varOfvarName = ToOrderFormatUtils.frmString(varOfvarDets.getItemName());
                            String varOfvarPrice = varOfvarDets.getItemPrice();
                            String varOfvarComment = ToOrderFormatUtils.frmString(varOfvarDets.getItemComment());
                            String varOfvarQty = "1.00";
                            String varOfvarDiscount = "0.00";
                            String varOfvarTotal = "0.00";
                            OrderItem gen_order_var_of_var = new OrderItem(item_poz, 1, "VOV", varOfvarId, varOfvarPosID, varOfvarName, varOfvarPrice, varOfvarQty, varOfvarDiscount, varOfvarTotal, varOfvarComment);
                            gen_order_items.add(gen_order_var_of_var);
                        }
                    }
                }
            }
        }
        return gen_order_items;
    }

    @Override
    public OrderLog getOrderLog(OrderAndMenu om) {
        return new OrderLog();
    }

    @Override
    public OrderRestaurant getOrderRestaurant(OrderAndMenu om) throws Exception {
        String rest_source_id = ToOrderFormatUtils.frmString(om.getOrder().restaurantId);
        String rest_local_id = this.getToOrderRestCode(rest_source_id);
        return new OrderRestaurant(rest_source_id, rest_local_id, rest_source_id);
    }

    @Override
    public String getToOrderRestCode(String SourceRestCod) throws Exception {
        String resp = "";
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        resp = dbc.execute("W $G(^[$$^W3MAIN]W3SOR2M(\"" + SourceRestCod + "\")) ", global_map);
        if (resp.equals("[]")) {
            throw new Exception("Restaurant not connected to POS DB");
        }
        return resp;
    }

    @Override
    public OrderSource getOrderSource(OrderAndMenu om) {
        return new OrderSource(15, "SeferHaOhel", om.getOrder().id);
    }

    @Override
    public OrderStatus getOrderStatus(OrderAndMenu om) {
        return new OrderStatus(1, "", "", "", "");
    }

    @Override
    public List<Payment> getOrderPayment(OrderAndMenu om) {
        LinkedList<Payment> gen_order_payment = new LinkedList<Payment>();
        for (com.wix.restaurants.payments.Payment pay : om.getOrder().payments) {
            String amount = ToOrderFormatUtils.frmAgorotToNis(pay.amount.toString());
            Payment gen_order_paytrn = new Payment();
            if (pay instanceof CreditcardPayment) {
                CreditcardPayment paycrd = new CreditcardPayment();
                paycrd = (CreditcardPayment)pay;
                CreditCard cc_dets = om.getCards().get(paycrd.cardToken.token());
                String cc_card_type = ToOrderFormatUtils.frmString("");
                String cc_number = ToOrderFormatUtils.frmString(cc_dets.number());
                String cc_mounth = String.valueOf(paycrd.cardToken.creditCard().expiration().month());
                cc_mounth = String.format("%2s", cc_mounth).replace(' ', '0');
                String cc_year = String.valueOf(paycrd.cardToken.creditCard().expiration().year());
                String cc_exp = cc_mounth + "/" + cc_year.substring(2);
                String cc_cvv = "";
                if (((CreditCardOptionalFields)cc_dets.additionalFields().get()).csc().isDefined()) {
                    cc_cvv = ToOrderFormatUtils.frmString((String)((CreditCardOptionalFields)cc_dets.additionalFields().get()).csc().get());
                }
                String cc_owner_id = "";
                if (((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderId().isDefined()) {
                    cc_owner_id = ToOrderFormatUtils.frmString((String)((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderId().get());
                }
                String cc_owner_name = "";
                if (((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderName().isDefined()) {
                    cc_owner_name = ToOrderFormatUtils.frmString((String)((PublicCreditCardOptionalFields)((CreditCardOptionalFields)cc_dets.additionalFields().get()).publicFields().get()).holderName().get());
                }
                String cc_owner_phone = "";
                PaymentCreditCardDets gen_order_credit = new PaymentCreditCardDets(cc_card_type, cc_number, cc_exp, cc_cvv, cc_owner_name, cc_owner_id, cc_owner_phone);
                gen_order_paytrn.setAmount(amount);
                gen_order_paytrn.setPayment_id(3);
                gen_order_paytrn.setPayment_type("CreditCard");
                gen_order_paytrn.setPayment_card_dets(gen_order_credit);
                gen_order_payment.add(gen_order_paytrn);
                continue;
            }
            gen_order_paytrn.setAmount(amount);
            gen_order_paytrn.setPayment_id(1);
            gen_order_paytrn.setPayment_type("Cash");
            gen_order_payment.add(gen_order_paytrn);
        }
        return gen_order_payment;
    }

    @Override
    public String getOrderDeliveryFee(OrderAndMenu om) {
        String dlvfee = ToOrderFormatUtils.frmAgorotToNis(om.getOrder().delivery.charge.toString());
        return dlvfee;
    }

    @Override
    public String getOrderDiscount(OrderAndMenu om) {
        String order_discount = ToOrderFormatUtils.frmIntToDecimal(null);
        if (om.getOrder().orderCharges == null) {
            return order_discount;
        }
        int i = 0;
        for (OrderCharge ch : om.getOrder().orderCharges) {
            i += ch.amount.intValue();
        }
        order_discount = ToOrderFormatUtils.frmAgorotToNis(Integer.toString(i *= -1));
        return order_discount;
    }

    @Override
    public String getOrderTotal(OrderAndMenu om) {
        String total = ToOrderFormatUtils.frmAgorotToNis(om.getOrder().price.toString());
        return total;
    }

    @Override
    public String getOrderComment(OrderAndMenu om) {
        String order_comment = ToOrderFormatUtils.frmString(om.getOrder().comment);
        return order_comment;
    }

    @Override
    public RestPosParams getRestPosParams(OrderAndMenu om) {
        return new RestPosParams();
    }

    @Override
    public int getNumOfDinners(OrderAndMenu om) {
        int takeoutPack = om.getOrder().takeoutPacks == null ? 0 : om.getOrder().takeoutPacks;
        return takeoutPack;
    }
}

