/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailUtil {
    public static void sendEmail(Session session, String toEmail, String subject, String body) {
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.addHeader("Content-type", "text/HTML; charset=UTF-8");
            msg.addHeader("format", "flowed");
            msg.addHeader("Content-Transfer-Encoding", "8bit");
            msg.setFrom((Address)new InternetAddress("no_reply@example.com", "NoReply-JD"));
            msg.setReplyTo((Address[])InternetAddress.parse((String)"no_reply@example.com", (boolean)false));
            msg.setSubject(subject, "UTF-8");
            msg.setText(body, "UTF-8");
            msg.setSentDate(new Date());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toEmail, (boolean)false));
            System.out.println("Message is ready");
            Transport.send((Message)msg);
            System.out.println("EMail Sent Successfully!!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendAttachmentEmail(Session session, String toEmail, String subject, String body, String attachFile) {
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.addHeader("Content-type", "text/HTML; charset=UTF-8");
            msg.addHeader("format", "flowed");
            msg.addHeader("Content-Transfer-Encoding", "8bit");
            msg.setFrom((Address)new InternetAddress("no_reply@example.com", "NoReply-JD"));
            msg.setReplyTo((Address[])InternetAddress.parse((String)"no_reply@example.com", (boolean)false));
            msg.setSubject(subject, "UTF-8");
            msg.setSentDate(new Date());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toEmail, (boolean)false));
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(body);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            String filename = attachFile;
            FileDataSource source = new FileDataSource(filename);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(filename);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
            System.out.println("EMail Sent Successfully with attachment!!");
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void sendImageEmail(Session session, String toEmail, String subject, String body) {
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.addHeader("Content-type", "text/HTML; charset=UTF-8");
            msg.addHeader("format", "flowed");
            msg.addHeader("Content-Transfer-Encoding", "8bit");
            msg.setFrom((Address)new InternetAddress("no_reply@example.com", "NoReply-JD"));
            msg.setReplyTo((Address[])InternetAddress.parse((String)"no_reply@example.com", (boolean)false));
            msg.setSubject(subject, "UTF-8");
            msg.setSentDate(new Date());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toEmail, (boolean)false));
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(body);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            String filename = "image.png";
            FileDataSource source = new FileDataSource(filename);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(filename);
            messageBodyPart.setHeader("Content-ID", "image_id");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)"<h1>Attached Image</h1><img src='cid:image_id'>", "text/html");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
            System.out.println("EMail Sent Successfully with image!!");
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

