/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.utility.beans.dates;

import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletRequest;

public class JspCalendar {
    Calendar calendar = Calendar.getInstance();
    int dSTOffset;

    public JspCalendar() {
        Date trialTime = new Date();
        this.calendar.setTime(trialTime);
    }

    public void processRequest(ServletRequest req) {
        System.out.println("processRequest method invoked");
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public String getMonth() {
        int m = this.getMonthInt();
        String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        if (m > 12) {
            return "Unknown to Man";
        }
        return months[m - 1];
    }

    public String getDay() {
        int x = this.getDayOfWeek();
        String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        if (x > 7) {
            return "Unknown to Man";
        }
        return days[x - 1];
    }

    public int getMonthInt() {
        return 1 + this.calendar.get(2);
    }

    public String getDate() {
        return this.getMonthInt() + "/" + this.getDayOfMonth() + "/" + this.getYear();
    }

    public String getTime() {
        return this.getHour() + ":" + this.getMinute() + ":" + this.getSecond();
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    public int getWeekOfYear() {
        return this.calendar.get(3);
    }

    public int getWeekOfMonth() {
        return this.calendar.get(4);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public static void main(String[] args) {
        JspCalendar db = new JspCalendar();
        JspCalendar.p("date: " + db.getDayOfMonth());
        JspCalendar.p("year: " + db.getYear());
        JspCalendar.p("month: " + db.getMonth());
        JspCalendar.p("time: " + db.getTime());
        JspCalendar.p("date: " + db.getDate());
        JspCalendar.p("Day: " + db.getDay());
        JspCalendar.p("DayOfYear: " + db.getDayOfYear());
        JspCalendar.p("WeekOfYear: " + db.getWeekOfYear());
        JspCalendar.p("era: " + db.getEra());
        JspCalendar.p("ampm: " + db.getAMPM());
        JspCalendar.p("DST: " + db.getDSTOffset());
        JspCalendar.p("ZONE Offset: " + db.getZoneOffset());
        JspCalendar.p("TIMEZONE: " + db.getUSTimeZone());
    }

    private static void p(String x) {
        System.out.println(x);
    }

    public int getEra() {
        return this.calendar.get(0);
    }

    public String getUSTimeZone() {
        String[] zones = new String[]{"Hawaii", "Alaskan", "Pacific", "Mountain", "Central", "Eastern"};
        return zones[10 + this.getZoneOffset()];
    }

    public int getZoneOffset() {
        return this.calendar.get(15) / 3600000;
    }

    public int getDSTOffset() {
        return this.calendar.get(16) / 3600000;
    }

    public int getAMPM() {
        return this.calendar.get(9);
    }
}

