/*
 * Decompiled with CFR 0.152.
 */
package com.cav.taglibs.mumps;

import com.cav.mserver.MumpsQuery;
import com.cav.mserver.MumpsSession;
import com.cav.mserver.MumpsSessionPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.pool.ObjectPool;

public class JSPMumpsSession {
    private static Logger logger = Logger.getLogger(JSPMumpsSession.class.getPackage().getName());
    private static final String M_SESSION_CLEAR_CODE = "D CLEAR^%ZCAVJSP";
    private static final MessageFormat M_SWITCH_NAMESPACE_CODE = new MessageFormat("D CWD^%ZCAVJSP(\"{0}\")");
    private static final MessageFormat M_GET_VAR_CODE = new MessageFormat("W {0}");
    private static final MessageFormat M_IF_CODE = new MessageFormat("I {0} W 1");
    private static final Map EMPTY_ARGS = new HashMap();
    private MumpsSession mSession = null;
    private JspWriter out;
    private static final String VERSION = "1.2.2";

    public JSPMumpsSession() throws Exception {
        this(null);
    }

    public JSPMumpsSession(JspWriter out) throws Exception {
        try {
            this.mSession = (MumpsSession)MumpsSessionPool.instance().borrowObject();
            this.clearSession();
        }
        catch (Exception e) {
            ObjectPool pool = MumpsSessionPool.instance();
            StringBuffer status = new StringBuffer("Idle jobs: ");
            status.append(pool.getNumIdle());
            status.append(". Active jobs: ");
            status.append(pool.getNumActive());
            logger.log(Level.SEVERE, "Error borrowing Mumps session. " + status, e);
            throw e;
        }
        this.out = out;
    }

    public void switchNamespace(String namespace, Map args2) {
        String command = M_SWITCH_NAMESPACE_CODE.format(new Object[]{namespace});
        this.executeCommand(command, args2);
    }

    private void executeCommand(String command, Map args2) {
        InputStream is = this.mSession.execute(command, args2);
        if (this.out != null) {
            try {
                this.out.println("<!-- RUNNING: " + command + ", ARGS=" + args2);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error writing commandto page: " + command, e);
            }
        }
        try {
            int c;
            while ((c = is.read()) != -1) {
                if (this.out == null) continue;
                this.out.print((char)c);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error reading command output: " + command, e);
        }
        if (this.out != null) {
            try {
                this.out.println(" -->");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error writing commandto page: " + command, e);
            }
        }
    }

    private String excuteCommandWithOutput(String command, Map args2) {
        StringBuffer buf = new StringBuffer();
        InputStreamReader is = null;
        try {
            is = new InputStreamReader(this.mSession.execute(command, args2), "ISO-8859-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "Error reading command output " + command, e);
            return "";
        }
        if (this.out != null) {
            try {
                this.out.println("<!-- RUNNING: " + command + ", ARGS=" + args2);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error writing command to page: " + command, e);
            }
        }
        try {
            int c;
            while ((c = is.read()) != -1) {
                buf.append((char)c);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error reading command output " + command, e);
            return "";
        }
        if (this.out != null) {
            try {
                this.out.print(buf.toString());
                this.out.println(" -->");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error writing commandto page: " + command, e);
            }
        }
        return buf.toString();
    }

    public String exec(String expr) {
        return this.excuteCommandWithOutput(expr, EMPTY_ARGS);
    }

    public String get(String expr) {
        String command = M_GET_VAR_CODE.format(new Object[]{expr});
        return this.excuteCommandWithOutput(command, EMPTY_ARGS);
    }

    public boolean check(String expr) {
        String checkExpr = M_IF_CODE.format(new Object[]{expr});
        String result2 = this.excuteCommandWithOutput(checkExpr, EMPTY_ARGS);
        logger.info("Result is <" + result2 + ">");
        return result2.trim().equals("1");
    }

    public MumpsQuery query(String command) throws Exception {
        MumpsQuery query = new MumpsQuery(command, EMPTY_ARGS);
        query.execute(this.mSession);
        return query;
    }

    public void set(String varName, String value) {
        HashMap<String, String> args2 = new HashMap<String, String>();
        args2.put(varName, value);
        this.executeCommand("", args2);
    }

    public void close() {
        this.clearSession();
        try {
            MumpsSessionPool.instance().returnObject((Object)this.mSession);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error releasing Mumps session", e);
        }
    }

    private void clearSession() {
        InputStream mumpsOutput = this.mSession.execute(M_SESSION_CLEAR_CODE, EMPTY_ARGS);
        try {
            while (mumpsOutput.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toMString(String str) {
        return "\"" + str.replaceAll("\"", "\"\"") + "\"";
    }

    static {
        logger.info("MJSP version 1.2.2 starting");
    }
}

