/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.frsvision.resources.pos.Error;
import com.frsvision.resources.pos.FrsvisionException;
import com.genorder.bean.GeneralOrder;
import com.genorder.bean.OrderItem;
import com.genorder.bean.Payment;
import com.openrest.resources.ConvertSoV3OrderToGeneralOrder;
import com.paypo.bean.OrderItemVariation;
import com.paypo.bean.OrderPayment;
import com.paypo.bean.PaypoOrder;
import java.util.LinkedList;
import java.util.List;

public class ConvertGeneralV3ToPaypoOrder
extends ConvertSoV3OrderToGeneralOrder {
    private PaypoOrder paypoOrder;

    public void convertGenToPaypoOrder() throws FrsvisionException {
        this.paypoOrder = new PaypoOrder();
        this.getPaypoOrder().getCustomer().setFirstName(this.getGord().getOrder_contact().get(0).getContact_firstname());
        this.getPaypoOrder().getCustomer().setLastName(this.getGord().getOrder_contact().get(0).getContact_lastname());
        if (this.getGord().getAddress().getCity().equals("TAW")) {
            this.getPaypoOrder().setDeliveryType("pickup");
        } else {
            this.getPaypoOrder().setDeliveryType("delivery");
        }
        this.getPaypoOrder().setId(this.getGord().getOrder_source().getSource_order_id());
        this.getPaypoOrder().getCustomer().setPhone(this.getGord().getOrder_contact().get(0).getContact_cellular());
        this.getPaypoOrder().setCreatedDate(this.getGord().getOrder_date_delivery().getTime());
        this.getPaypoOrder().getAddress().setCity(this.getGord().getAddress().getCity());
        this.getPaypoOrder().getAddress().setStreet(this.getGord().getAddress().getStreet());
        this.getPaypoOrder().getAddress().setNumber(this.getGord().getAddress().getHouse_number());
        this.getPaypoOrder().getAddress().setEntrance(this.getGord().getAddress().getEntrance());
        this.getPaypoOrder().getAddress().setFloor(this.getGord().getAddress().getFloor_num());
        this.getPaypoOrder().getAddress().setApt(this.getGord().getAddress().getAppartment());
        this.getPaypoOrder().setDeliveryFee(Double.valueOf(this.getGord().getDelivery_fee()));
        this.getPaypoOrder().setCommment(this.getGord().getAddress().getAddress_remark() + " " + this.getGord().getOrder_remark());
        this.getPaypoOrder().setItems(this.getOrderItems(this.getGord()));
        this.getPaypoOrder().setPayments(this.getPaymentList(this.getGord()));
    }

    private List<OrderPayment> getPaymentList(GeneralOrder gen_ord) {
        LinkedList<OrderPayment> paypo_payment_list = new LinkedList<OrderPayment>();
        for (Payment genord_pay : gen_ord.getPayments()) {
            OrderPayment paypo_payment = new OrderPayment();
            paypo_payment.setAmount(Double.valueOf(genord_pay.getAmount()));
            if (genord_pay.getPayment_id() == 3) {
                paypo_payment.setCardSuffix(null);
                paypo_payment.setTransactionId(null);
                paypo_payment.setType("credit_card");
            }
            if (genord_pay.getPayment_id() == 1) {
                paypo_payment.setType("cash");
            }
            paypo_payment_list.add(paypo_payment);
        }
        if (gen_ord.getOrder_discount() != "") {
            OrderPayment paypo_payment = new OrderPayment();
            paypo_payment.setAmount(Double.valueOf(gen_ord.getOrder_discount()));
            paypo_payment.setType("discount");
            paypo_payment_list.add(paypo_payment);
        }
        return paypo_payment_list;
    }

    private List<com.paypo.bean.OrderItem> getOrderItems(GeneralOrder gen_ord) throws FrsvisionException {
        LinkedList<com.paypo.bean.OrderItem> paypo_item_list = new LinkedList<com.paypo.bean.OrderItem>();
        LinkedList<OrderItemVariation> paypo_var_list = new LinkedList<OrderItemVariation>();
        String item_code = "";
        String item_type = "";
        String main_item_code = "";
        for (OrderItem itm : gen_ord.getOrder_items()) {
            com.paypo.bean.OrderItem paypo_item = new com.paypo.bean.OrderItem();
            OrderItemVariation paypo_topping = new OrderItemVariation();
            item_code = itm.getItem_pos_id();
            item_type = "";
            try {
                paypo_item.setId(Integer.valueOf(itm.getItem_pos_id()));
                paypo_item.setName(itm.getItem_name());
                paypo_item.setPrice(Double.valueOf(itm.getItem_price()));
                paypo_item.setQuantity(Integer.valueOf(itm.getItem_qty()));
                paypo_item.setRemarks(itm.getItem_comment());
                int itm_lvl = itm.getItem_level();
                if (itm_lvl > 0) {
                    paypo_topping.getItems().add(paypo_item);
                    continue;
                }
                paypo_item.setId(Integer.valueOf(itm.getItem_pos_id()));
                paypo_item.setName(itm.getItem_name());
                paypo_item.setPrice(Double.valueOf(itm.getItem_price()));
                paypo_item.setQuantity(Integer.valueOf(itm.getItem_qty()));
                paypo_item.setRemarks(itm.getItem_comment());
                if (paypo_var_list != null) {
                    paypo_item.setVariations(paypo_var_list);
                    paypo_var_list = null;
                }
                main_item_code = item_code;
                paypo_item_list.add(paypo_item);
            }
            catch (NumberFormatException ex) {
                throw new FrsvisionException(new Error(Error.ERROR_POS_MISSING_ITEM_NUMBER, "Pos item id isn't numeric " + itm.getItem_source_id() + "|" + itm.getItem_name()));
            }
        }
        return paypo_item_list;
    }

    public PaypoOrder getPaypoOrder() {
        return this.paypoOrder;
    }

    public void setPaypoOrder(PaypoOrder paypoOrder) {
        this.paypoOrder = paypoOrder;
    }
}

