/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wix.restaurants.conditions.Condition;
import com.wix.restaurants.i18n.LocalizedString;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MenuSection
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String id;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString title = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString description = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<MenuSection> children = new LinkedList<MenuSection>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<String> itemIds = new LinkedList<String>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Condition displayCondition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Condition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> media = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();

    public MenuSection(String id, LocalizedString title, LocalizedString description, List<MenuSection> children, List<String> itemIds, Condition displayCondition, Condition condition, Map<String, String> media, Map<String, String> properties) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.children = children;
        this.itemIds = itemIds;
        this.displayCondition = displayCondition;
        this.condition = condition;
        this.media = media;
        this.properties = properties;
    }

    public MenuSection() {
    }

    public MenuSection clone() {
        return new MenuSection(this.id, this.title != null ? this.title.clone() : null, this.description != null ? this.description.clone() : null, MenuSection.clone(this.children), this.itemIds != null ? new LinkedList<String>(this.itemIds) : null, this.displayCondition != null ? this.displayCondition.clone() : null, this.condition != null ? this.condition.clone() : null, this.media != null ? new LinkedHashMap<String, String>(this.media) : null, (Map<String, String>)(this.properties != null ? new LinkedHashMap<String, String>(this.properties) : null));
    }

    public static List<MenuSection> clone(List<MenuSection> sections) {
        if (sections == null) {
            return null;
        }
        LinkedList<MenuSection> cloned = new LinkedList<MenuSection>();
        for (MenuSection section : sections) {
            cloned.add(section != null ? section.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuSection that = (MenuSection)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.children, that.children) && Objects.equals(this.itemIds, that.itemIds) && Objects.equals(this.displayCondition, that.displayCondition) && Objects.equals(this.condition, that.condition) && Objects.equals(this.media, that.media) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.children, this.itemIds, this.displayCondition, this.condition, this.media, this.properties);
    }

    public String toString() {
        return "MenuSection{id='" + this.id + '\'' + ", title=" + this.title + ", description=" + this.description + ", children=" + this.children + ", itemIds=" + this.itemIds + ", displayCondition=" + this.displayCondition + ", condition=" + this.condition + ", media=" + this.media + ", properties=" + this.properties + '}';
    }
}

