/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class State {
    public static final String STATE_DEMO = "demo";
    public static final String STATE_UNDER_CONSTRUCTION = "under_construction";
    public static final String STATE_OPERATIONAL = "operational";
    public static final String STATE_CLOSED = "closed";
    public static final String STATE_INFO = "info";
    public static final Set<String> ALL_STATES = new HashSet<String>(Arrays.asList("demo", "under_construction", "operational", "closed", "info"));
    private static Map<String, Integer> STATE_RANKS = State.getStateRanksMap();

    private State() {
    }

    public static int compare(String state1, String state2) {
        return State.getStateRank(state1) - State.getStateRank(state2);
    }

    private static Map<String, Integer> getStateRanksMap() {
        HashMap<String, Integer> ranks = new HashMap<String, Integer>();
        ranks.put(STATE_OPERATIONAL, 0);
        ranks.put(STATE_INFO, 1);
        ranks.put(STATE_UNDER_CONSTRUCTION, 2);
        ranks.put(STATE_DEMO, 3);
        ranks.put(STATE_CLOSED, 4);
        return Collections.unmodifiableMap(ranks);
    }

    private static int getStateRank(String state) {
        if (state == null) {
            return Integer.MAX_VALUE;
        }
        Integer rank = STATE_RANKS.get(state);
        return rank != null ? rank : Integer.MAX_VALUE;
    }
}

