/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPInputStream;
import com.enterprisedt.net.ftp.FTPOutputStream;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import com.enterprisedt.net.ftp.test.TestProgressMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestStream
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestStream.java,v 1.3 2012/11/15 06:09:27 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestStream;

    protected String getLogName() {
        return "TestStream.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferBinaryStreamDownload() throws Exception {
        log.debug("testTransferBinaryStreamDownload()");
        try {
            InputStream str;
            String filename;
            block7: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.BINARY);
                filename = this.generateRandomFilename();
                this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
                str = this.getInputStream(this.ftp, filename);
                FilterOutputStream out = null;
                try {
                    byte[] chunk = new byte[4096];
                    int count = 0;
                    out = new BufferedOutputStream(new FileOutputStream(this.localDataDir + filename));
                    while ((count = str.read(chunk)) >= 0) {
                        ((BufferedOutputStream)out).write(chunk, 0, count);
                    }
                    ((BufferedOutputStream)out).flush();
                    Object var7_8 = null;
                    if (out == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (out != null) {
                        out.close();
                    }
                    str.close();
                    throw throwable;
                }
                out.close();
            }
            str.close();
            this.ftp.delete(filename);
            this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferBinaryStreamDownloadSkip() throws Exception {
        log.debug("testTransferBinaryStreamDownloadSkip()");
        try {
            InputStream str;
            long skip;
            String filename;
            block7: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.BINARY);
                filename = this.generateRandomFilename();
                this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
                long length = this.ftp.size(filename);
                skip = length / 10L;
                log.debug("Length=" + length + ", skip=" + skip);
                str = this.getInputStream(this.ftp, filename);
                str.skip(skip);
                FilterOutputStream out = null;
                try {
                    byte[] chunk = new byte[4096];
                    int count = 0;
                    out = new BufferedOutputStream(new FileOutputStream(this.localDataDir + filename));
                    while ((count = str.read(chunk)) >= 0) {
                        ((BufferedOutputStream)out).write(chunk, 0, count);
                    }
                    ((BufferedOutputStream)out).flush();
                    Object var11_11 = null;
                    if (out == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (out != null) {
                        out.close();
                    }
                    str.close();
                    throw throwable;
                }
                out.close();
            }
            str.close();
            String filename2 = filename + "2";
            this.ftp.resumeNextDownload(skip);
            this.ftp.get(this.localDataDir + filename2, filename);
            this.ftp.delete(filename);
            this.assertIdentical(this.localDataDir + filename2, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            local = new File(this.localDataDir + filename2);
            local.delete();
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferBinaryStreamDownloadSkip2() throws Exception {
        log.debug("testTransferBinaryStreamDownloadSkip2()");
        try {
            long size;
            InputStream str;
            long skip;
            String filename;
            block8: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.BINARY);
                filename = this.generateRandomFilename();
                this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
                long length = this.ftp.size(filename);
                skip = length / 10L;
                log.debug("Length=" + length + ", skip=" + skip);
                str = this.getInputStream(this.ftp, filename);
                size = 0L;
                FilterOutputStream out = null;
                try {
                    byte[] chunk = new byte[4096];
                    int count = 0;
                    while ((count = str.read(chunk)) >= 0 && (size += (long)count) <= skip) {
                    }
                    str.skip(skip);
                    out = new BufferedOutputStream(new FileOutputStream(this.localDataDir + filename));
                    while ((count = str.read(chunk)) >= 0) {
                        ((BufferedOutputStream)out).write(chunk, 0, count);
                    }
                    ((BufferedOutputStream)out).flush();
                    Object var13_12 = null;
                    if (out == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (out != null) {
                        out.close();
                    }
                    str.close();
                    throw throwable;
                }
                out.close();
            }
            str.close();
            String filename2 = filename + "2";
            this.ftp.resumeNextDownload(size + skip);
            this.ftp.get(this.localDataDir + filename2, filename);
            this.ftp.delete(filename);
            this.assertIdentical(this.localDataDir + filename2, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            local = new File(this.localDataDir + filename2);
            local.delete();
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferBinaryStreamDownloadSkipReset() throws Exception {
        log.debug("testTransferBinaryStreamDownloadSkipReset()");
        try {
            byte[] second;
            byte[] first;
            int shortSkip;
            InputStream str;
            String filename;
            block8: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.BINARY);
                filename = this.generateRandomFilename();
                this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
                long length = this.ftp.size(filename);
                long skip = length - 132072L;
                log.debug("Length=" + length + ", skip=" + skip);
                str = this.getInputStream(this.ftp, filename);
                str.skip(skip);
                str.mark(0);
                shortSkip = 60000;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                first = null;
                second = null;
                try {
                    byte[] chunk = new byte[8192];
                    int count = 0;
                    while ((count = str.read(chunk)) >= 0) {
                        out.write(chunk, 0, count);
                    }
                    first = out.toByteArray();
                    out.reset();
                    str.reset();
                    str.skip(shortSkip);
                    while ((count = str.read(chunk)) >= 0) {
                        out.write(chunk, 0, count);
                    }
                    second = out.toByteArray();
                    Object var14_13 = null;
                    if (out == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    if (out != null) {
                        out.close();
                    }
                    str.close();
                    throw throwable;
                }
                out.close();
            }
            str.close();
            this.ftp.delete(filename);
            byte[] firstPart = new byte[first.length - shortSkip];
            System.arraycopy(first, shortSkip, firstPart, 0, first.length - shortSkip);
            this.assertIdentical(firstPart, second);
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferBinaryStreamDownloadReset() throws Exception {
        log.debug("testTransferBinaryStreamDownloadReset()");
        try {
            InputStream str;
            byte[] second;
            byte[] first;
            String filename;
            block9: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.BINARY);
                filename = this.generateRandomFilename();
                this.ftp.put(this.localDataDir + this.localBinaryFile, filename);
                long length = this.ftp.size(filename);
                long markpos = length / 10L;
                log.debug("Length=" + length + ", markpos=" + markpos);
                first = null;
                second = null;
                str = this.getInputStream(this.ftp, filename);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    byte[] chunk = new byte[4096];
                    int count = 0;
                    long size = 0L;
                    while ((count = str.read(chunk)) >= 0 && (size += (long)count) <= markpos) {
                    }
                    str.mark(0);
                    markpos = size;
                    while ((count = str.read(chunk)) >= 0) {
                        out.write(chunk, 0, count);
                        if ((size += (long)count) <= markpos * 2L) continue;
                    }
                    first = out.toByteArray();
                    str.reset();
                    size = markpos;
                    out.close();
                    out = new ByteArrayOutputStream();
                    while ((count = str.read(chunk)) >= 0) {
                        out.write(chunk, 0, count);
                        if ((size += (long)count) <= markpos * 2L) continue;
                    }
                    second = out.toByteArray();
                    Object var15_13 = null;
                    if (out == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var15_14 = null;
                    if (out != null) {
                        out.close();
                    }
                    str.close();
                    throw throwable;
                }
                out.close();
            }
            str.close();
            this.ftp.delete(filename);
            this.assertIdentical(first, second);
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferBinaryStreamUpload() throws Exception {
        log.debug("testTransferBinaryStreamDownload()");
        try {
            OutputStream out;
            String filename;
            block7: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.BINARY);
                filename = this.generateRandomFilename();
                out = this.getOutputStream(this.ftp, filename);
                BufferedInputStream in = null;
                try {
                    byte[] chunk = new byte[4096];
                    int count = 0;
                    in = new BufferedInputStream(new FileInputStream(this.localDataDir + this.localBinaryFile));
                    while ((count = in.read(chunk)) >= 0) {
                        out.write(chunk, 0, count);
                    }
                    out.flush();
                    Object var7_8 = null;
                    if (in == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (in != null) {
                        in.close();
                    }
                    out.close();
                    throw throwable;
                }
                in.close();
            }
            out.close();
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            this.assertIdentical(this.localDataDir + this.localBinaryFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferASCIIStreamDownload() throws Exception {
        log.debug("testTransferASCIIStreamDownload()");
        try {
            InputStream str;
            String filename;
            block7: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.ASCII);
                filename = this.generateRandomFilename();
                this.ftp.put(this.localDataDir + this.localTextFile, filename);
                str = this.getInputStream(this.ftp, filename);
                FilterOutputStream out = null;
                try {
                    byte[] chunk = new byte[4096];
                    int count = 0;
                    out = new BufferedOutputStream(new FileOutputStream(this.localDataDir + filename));
                    while ((count = str.read(chunk)) >= 0) {
                        ((BufferedOutputStream)out).write(chunk, 0, count);
                    }
                    ((BufferedOutputStream)out).flush();
                    Object var7_8 = null;
                    if (out == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (out != null) {
                        out.close();
                    }
                    str.close();
                    throw throwable;
                }
                out.close();
            }
            str.close();
            this.ftp.delete(filename);
            this.assertIdentical(this.localDataDir + this.localTextFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTransferASCIIStreamUpload() throws Exception {
        log.debug("testTransferASCIIStreamUpload()");
        try {
            OutputStream out;
            String filename;
            block7: {
                this.connect();
                this.ftp.setProgressMonitor(new TestProgressMonitor(), 8192L);
                this.ftp.chdir(this.testdir);
                this.ftp.setType(FTPTransferType.ASCII);
                filename = this.generateRandomFilename();
                out = this.getOutputStream(this.ftp, filename);
                BufferedInputStream in = null;
                try {
                    byte[] chunk = new byte[4096];
                    int count = 0;
                    in = new BufferedInputStream(new FileInputStream(this.localDataDir + this.localTextFile));
                    while ((count = in.read(chunk)) >= 0) {
                        out.write(chunk, 0, count);
                    }
                    out.flush();
                    Object var7_8 = null;
                    if (in == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (in != null) {
                        in.close();
                    }
                    out.close();
                    throw throwable;
                }
                in.close();
            }
            out.close();
            this.ftp.get(this.localDataDir + filename, filename);
            this.ftp.delete(filename);
            this.assertIdentical(this.localDataDir + this.localTextFile, this.localDataDir + filename);
            File local = new File(this.localDataDir + filename);
            local.delete();
            this.ftp.quit();
            return;
        }
        catch (ClassCastException ex) {
            log.info("Only FTPClient (and subclasses) supports streaming");
            this.ftp.quit();
            return;
        }
        catch (Exception ex) {
            log.error("Unexpected error", ex);
            this.ftp.quitImmediately();
            throw ex;
        }
    }

    protected OutputStream getOutputStream(FTPClientInterface ftp, String filename) throws IOException, FTPException {
        return new FTPOutputStream((FTPClient)ftp, filename);
    }

    protected InputStream getInputStream(FTPClientInterface ftp, String filename) throws IOException, FTPException {
        return new FTPInputStream((FTPClient)ftp, filename);
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestStream == null ? (class$com$enterprisedt$net$ftp$test$TestStream = TestStream.class$("com.enterprisedt.net.ftp.test.TestStream")) : class$com$enterprisedt$net$ftp$test$TestStream);
    }

    public static void main(String[] args2) {
        TestRunner.run((Test)TestStream.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

