/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.introspect;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.scala.introspect.BeanDescriptor;
import com.fasterxml.jackson.module.scala.introspect.ConstructorParameter;
import com.fasterxml.jackson.module.scala.introspect.PropertyDescriptor;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class BeanIntrospector$ {
    public static BeanIntrospector$ MODULE$;
    private final CachingParanamer paranamer;

    static {
        new BeanIntrospector$();
    }

    private String[] getCtorParams(Constructor<?> ctor) {
        return (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.paranamer.lookupParameterNames(ctor, false))).map((Function1<String, String> & Serializable & scala.Serializable)name0 -> NameTransformer$.MODULE$.decode((String)name0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public <T> BeanDescriptor apply(Manifest<?> mf) {
        return this.apply(mf.runtimeClass());
    }

    public <T> BeanDescriptor apply(Class<?> cls2) {
        List hierarchy = this.next$1(cls2, Nil$.MODULE$);
        Regex privateRegex = new StringOps(Predef$.MODULE$.augmentString("(.*)\\$\\$(.*)")).r();
        Seq fields = hierarchy.flatMap((Function1<Class, Object> & Serializable & scala.Serializable)cls -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields())).map((Function1<Field, Tuple2> & Serializable & scala.Serializable)field2 -> {
            String name = BeanIntrospector$.maybePrivateName$1(field2, privateRegex$1);
            return new Tuple2<Field, String>((Field)field2, name);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1<Object, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$16(x$4))).withFilter((Function1<Object, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$17(x$5))).map((Function1<Tuple2, Tuple3> & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._2();
            Option beanGetter2 = BeanIntrospector$.findBeanGetter$1(cls, name);
            Option beanSetter2 = BeanIntrospector$.findBeanSetter$1(cls, name);
            Tuple3<Tuple2, Option, Option> tuple3 = new Tuple3<Tuple2, Option, Option>(tuple2, beanGetter2, beanSetter2);
            return tuple3;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).map((Function1<Tuple3, PropertyDescriptor> & Serializable & scala.Serializable)x$8 -> {
            Option beanSetter2;
            Option beanGetter2;
            Tuple2 tuple2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$8;
                    if (tuple3 == null) break block2;
                    tuple2 = (Tuple2)tuple3._1();
                    beanGetter2 = (Option)tuple3._2();
                    beanSetter2 = (Option)tuple3._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Field field2 = (Field)tuple2._1();
            String name = (String)tuple2._2();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, $this.findConstructorParam$1((Class)hierarchy$1.head(), name), new Some<Field>(field2), BeanIntrospector$.findGetter$1(cls, name), BeanIntrospector$.findSetter$1(cls, name), beanGetter2, beanSetter2);
            return propertyDescriptor;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PropertyDescriptor.class))))), Seq$.MODULE$.canBuildFrom());
        Seq methods = hierarchy.flatMap((Function1<Class, Object> & Serializable & scala.Serializable)cls -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredMethods())).map((Function1<Method, Tuple2> & Serializable & scala.Serializable)getter2 -> {
            String name = NameTransformer$.MODULE$.decode(getter2.getName());
            return new Tuple2<Method, String>((Method)getter2, name);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1<Object, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$22(x$10))).withFilter((Function1<Object, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$23(cls, x$11))).withFilter((Function1<Object, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$24(x$12))).withFilter((Function1<Object, Object>)(Function1<Tuple2, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$25(fields$1, x$13))).map((Function1<Tuple2, Tuple3> & Serializable & scala.Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Method getter2 = (Method)tuple2._1();
            String name = (String)tuple2._2();
            JsonProperty getterProperty = getter2.getAnnotation(JsonProperty.class);
            Option setter2 = BeanIntrospector$.findSetter$1(cls, name);
            Tuple3<Tuple2, JsonProperty, Option> tuple3 = new Tuple3<Tuple2, JsonProperty, Option>(tuple2, getterProperty, setter2);
            return tuple3;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).withFilter((Function1<Object, Object>)(Function1<Tuple3, Object> & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$28(x$16))).map((Function1<Tuple3, Tuple3> & Serializable & scala.Serializable)x$18 -> {
            Tuple2 tuple2;
            Tuple3 tuple3 = x$18;
            if (tuple3 == null || (tuple2 = (Tuple2)tuple3._1()) == null) {
                throw new MatchError(tuple3);
            }
            String name = (String)tuple2._2();
            Option beanGetter2 = BeanIntrospector$.findBeanGetter$1(cls, name);
            Option beanSetter2 = BeanIntrospector$.findBeanSetter$1(cls, name);
            Tuple3<Tuple3, Option, Option> tuple32 = new Tuple3<Tuple3, Option, Option>(tuple3, beanGetter2, beanSetter2);
            return tuple32;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).map((Function1<Tuple3, PropertyDescriptor> & Serializable & scala.Serializable)x$19 -> {
            Option setter2;
            Tuple2 tuple2;
            Option beanSetter2;
            Option beanGetter2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$19;
                    if (tuple3 == null) break block2;
                    Tuple3 tuple32 = (Tuple3)tuple3._1();
                    beanGetter2 = (Option)tuple3._2();
                    beanSetter2 = (Option)tuple3._3();
                    if (tuple32 == null) break block2;
                    tuple2 = (Tuple2)tuple32._1();
                    setter2 = (Option)tuple32._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Method getter2 = (Method)tuple2._1();
            String name = (String)tuple2._2();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, None$.MODULE$, None$.MODULE$, new Some<Method>(getter2), setter2, beanGetter2, beanSetter2);
            return propertyDescriptor;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PropertyDescriptor.class))))), Seq$.MODULE$.canBuildFrom());
        return new BeanDescriptor(cls2, fields.$plus$plus(methods, Seq$.MODULE$.canBuildFrom()));
    }

    private final Option findConstructorParam$1(Class c, String name) {
        int index;
        Option<Object> primaryConstructor;
        while (true) {
            block4: {
                block3: {
                    if (c == null) break block3;
                    Class clazz = c;
                    Class<Object> clazz2 = Object.class;
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block4;
                }
                return None$.MODULE$;
            }
            primaryConstructor = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])c.getConstructors())).headOption();
            IndexedSeq debugCtorParamNames = Option$.MODULE$.option2Iterable(primaryConstructor).toIndexedSeq().flatMap((Function1<Constructor, Object> & Serializable & scala.Serializable)ctor -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])BeanIntrospector$.MODULE$.getCtorParams(ctor))), IndexedSeq$.MODULE$.canBuildFrom());
            index = debugCtorParamNames.indexOf(name);
            if (index >= 0) break;
            c = c.getSuperclass();
        }
        return new Some<ConstructorParameter>(new ConstructorParameter((Constructor)primaryConstructor.get(), index, None$.MODULE$));
    }

    private final List next$1(Class c, List acc) {
        while (c != null) {
            Class clazz = c;
            Class<Object> clazz2 = Object.class;
            if (clazz == null) {
                if (clazz2 == null) break;
            } else if (clazz.equals(clazz2)) break;
            acc = acc.$colon$plus(c, List$.MODULE$.canBuildFrom());
            c = c.getSuperclass();
        }
        return acc;
    }

    private static final Stream listMethods$1(Class cls) {
        Stream<Object> stream;
        Class clazz = cls;
        if (clazz == null) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            Class clazz2 = clazz;
            Class<Object> clazz3 = Object.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                stream = package$.MODULE$.Stream().empty();
            } else {
                Stream<Object> stream2 = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])clazz.getDeclaredMethods())).toStream();
                stream = Stream$.MODULE$.consWrapper((Function0<Stream> & Serializable & scala.Serializable)() -> BeanIntrospector$.listMethods$1(clazz.getSuperclass())).$hash$colon$colon$colon(stream2);
            }
        }
        return stream;
    }

    private static final boolean isNotSyntheticOrBridge$1(Method m) {
        return !m.isBridge() && !m.isSynthetic();
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(String name$1, Method m) {
        String string = NameTransformer$.MODULE$.decode(m.getName());
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Seq findMethod$1(Class cls, String name) {
        return (Seq)((TraversableLike)BeanIntrospector$.listMethods$1(cls).filter((Function1<Method, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean(BeanIntrospector$.isNotSyntheticOrBridge$1(m)))).filter((Function1<Method, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$4(name, m)));
    }

    private static final Stream listFields$1(Class cls) {
        Stream<Object> stream;
        Class clazz = cls;
        if (clazz == null) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            Class clazz2 = clazz;
            Class<Object> clazz3 = Object.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                stream = package$.MODULE$.Stream().empty();
            } else {
                Stream<Object> stream2 = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])clazz.getDeclaredFields())).toStream();
                stream = Stream$.MODULE$.consWrapper((Function0<Stream> & Serializable & scala.Serializable)() -> BeanIntrospector$.listFields$1(clazz.getSuperclass())).$hash$colon$colon$colon(stream2);
            }
        }
        return stream;
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(Field x$3) {
        return !x$3.isSynthetic();
    }

    public static final /* synthetic */ boolean $anonfun$apply$7(String fieldName$1, Field f) {
        String string = NameTransformer$.MODULE$.decode(f.getName());
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Option findField$1(Class cls, String fieldName) {
        return Option$.MODULE$.option2Iterable(((LinearSeqOptimized)BeanIntrospector$.listFields$1(cls).filter((Function1<Field, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$6(x$3)))).find((Function1<Field, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$7(fieldName, f)))).headOption();
    }

    private static final boolean isAcceptableField$1(Field field2) {
        int modifiers = field2.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers) && !Modifier.isTransient(modifiers) && !field2.isSynthetic();
    }

    private static final boolean isAcceptableMethod$1(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && BeanIntrospector$.isNotSyntheticOrBridge$1(method);
    }

    private static final Option findGetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, propertyName).find((Function1<Method, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean(BeanIntrospector$.isAcceptableGetter$1(m)));
    }

    private static final Option findBeanGetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, "get" + new StringOps(Predef$.MODULE$.augmentString(propertyName)).capitalize()).find((Function1<Method, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean(BeanIntrospector$.isAcceptableGetter$1(m)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAcceptableGetter$1(Method m) {
        if (!BeanIntrospector$.isAcceptableMethod$1(m)) return false;
        if (m.getParameterTypes().length != 0) return false;
        Class<?> clazz = m.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    private static final Option findSetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, propertyName + "_=").find((Function1<Method, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean(BeanIntrospector$.isAcceptableSetter$1(m)));
    }

    private static final Option findBeanSetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, "set" + new StringOps(Predef$.MODULE$.augmentString(propertyName)).capitalize()).find((Function1<Method, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean(BeanIntrospector$.isAcceptableSetter$1(m)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAcceptableSetter$1(Method m) {
        if (!BeanIntrospector$.isAcceptableMethod$1(m)) return false;
        if (m.getParameterTypes().length != 1) return false;
        Class<?> clazz = m.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz != null) {
            if (!clazz.equals(clazz2)) return false;
            return true;
        }
        if (clazz2 == null) return true;
        return false;
    }

    private static final String maybePrivateName$1(Field field2, Regex privateRegex$1) {
        Option option;
        String definedName = NameTransformer$.MODULE$.decode(field2.getName());
        try {
            option = Option$.MODULE$.apply(field2.getDeclaringClass().getCanonicalName());
        }
        catch (InternalError e) {
            option = None$.MODULE$;
        }
        Option canonicalName = option;
        return (String)canonicalName.flatMap((Function1<String, Option> & Serializable & scala.Serializable)cn -> {
            void var3_11;
            String PrivateName = cn.replace('.', '$');
            String string = definedName;
            Option<List<String>> option = privateRegex$1.unapplySeq(string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String string2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                String rest = (String)((LinearSeqOptimized)option.get()).apply(1);
                String string3 = PrivateName;
                String string4 = string2;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    Some<String> some = new Some<String>(rest);
                    return var3_11;
                }
            }
            None$ none$ = None$.MODULE$;
            return var3_11;
        }).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> definedName);
    }

    public static final /* synthetic */ boolean $anonfun$apply$16(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !new StringOps(Predef$.MODULE$.augmentString(name)).contains(BoxesRunTime.boxToCharacter('$'));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Field field2 = (Field)tuple2._1();
        boolean bl = BeanIntrospector$.isAcceptableField$1(field2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$22(Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Method getter2 = (Method)tuple2._1();
        boolean bl = BeanIntrospector$.isAcceptableGetter$1(getter2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$23(Class cls$2, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = BeanIntrospector$.findField$1(cls$2, name).isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$24(Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !new StringOps(Predef$.MODULE$.augmentString(name)).contains(BoxesRunTime.boxToCharacter('$'));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$26(String name$2, PropertyDescriptor x$9) {
        String string = x$9.name();
        String string2 = name$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$25(Seq fields$1, Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !fields$1.exists((Function1<PropertyDescriptor, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(BeanIntrospector$.$anonfun$apply$26(name, x$9)));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$apply$28(Tuple3 x$16) {
        Tuple3 tuple3 = x$16;
        if (tuple3 == null) throw new MatchError(tuple3);
        Tuple2 tuple2 = (Tuple2)tuple3._1();
        JsonProperty getterProperty = (JsonProperty)tuple3._2();
        Option setter2 = (Option)tuple3._3();
        if (tuple2 == null) throw new MatchError(tuple3);
        if (setter2.isDefined()) return true;
        if (getterProperty == null) return false;
        String string = getterProperty.value();
        String string2 = "";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    private BeanIntrospector$() {
        MODULE$ = this;
        this.paranamer = new CachingParanamer(new BytecodeReadingParanamer());
    }
}

