/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.frsvision.resources.pos.Error;
import com.frsvision.resources.pos.FrsvisionException;
import com.genorder.bean.GeneralOrder;
import com.genorder.bean.OrderItem;
import com.genorder.bean.Payment;
import com.openrest.resources.ConvertSoV3OrderToGeneralOrder;
import com.paypo.bean.OrderItemVariation;
import com.paypo.bean.OrderPayment;
import com.paypo.bean.PaypoOrder;
import java.util.LinkedList;
import java.util.List;

public class ConvertGeneralV3ToPaypoOrder
extends ConvertSoV3OrderToGeneralOrder {
    private PaypoOrder paypoOrder;

    public void convertGenToPaypoOrder() throws FrsvisionException {
        this.paypoOrder = new PaypoOrder();
        this.getPaypoOrder().getCustomer().setFirstName(this.getGord().getOrder_contact().get(0).getContact_firstname());
        this.getPaypoOrder().getCustomer().setLastName(this.getGord().getOrder_contact().get(0).getContact_lastname());
        if (this.getGord().getAddress().getCity().equals("TAW")) {
            this.getPaypoOrder().setDeliveryType("pickup");
        } else {
            this.getPaypoOrder().setDeliveryType("delivery");
        }
        this.getPaypoOrder().setId(this.getGord().getOrder_source().getSource_order_id());
        this.getPaypoOrder().getCustomer().setPhone(this.getGord().getOrder_contact().get(0).getContact_cellular());
        this.getPaypoOrder().setCreatedDate(this.getGord().getOrder_date_delivery().getTime() / 1000L);
        this.getPaypoOrder().getAddress().setCity(this.getGord().getAddress().getCity());
        this.getPaypoOrder().getAddress().setStreet(this.getGord().getAddress().getStreet());
        this.getPaypoOrder().getAddress().setNumber(this.getGord().getAddress().getHouse_number());
        this.getPaypoOrder().getAddress().setEntrance(this.getGord().getAddress().getEntrance());
        this.getPaypoOrder().getAddress().setFloor(this.getGord().getAddress().getFloor_num());
        this.getPaypoOrder().getAddress().setApt(this.getGord().getAddress().getAppartment());
        this.getPaypoOrder().setDeliveryFee(Double.valueOf(this.getGord().getDelivery_fee().replace(".", "")));
        this.getPaypoOrder().setComments(this.getGord().getAddress().getAddress_remark() + " " + this.getGord().getOrder_remark());
        this.getPaypoOrder().setItems(this.getOrderItems(this.getGord()));
        this.getPaypoOrder().setPayments(this.getPaymentList(this.getGord()));
        this.getPaypoOrder().setStatus(Integer.valueOf("0"));
    }

    private List<OrderPayment> getPaymentList(GeneralOrder gen_ord) {
        LinkedList<OrderPayment> paypo_payment_list = new LinkedList<OrderPayment>();
        for (Payment genord_pay : gen_ord.getPayments()) {
            OrderPayment paypo_payment = new OrderPayment();
            paypo_payment.setAmount(Integer.valueOf(genord_pay.getAmount().replace(".", "")));
            if (genord_pay.getPayment_id() == 3) {
                paypo_payment.setCardSuffix(null);
                paypo_payment.setTransactionId(null);
                paypo_payment.setType("credit_card");
            }
            if (genord_pay.getPayment_id() == 1) {
                paypo_payment.setType("cash");
            }
            paypo_payment_list.add(paypo_payment);
        }
        if (!gen_ord.getOrder_discount().isEmpty()) {
            OrderPayment paypo_payment = new OrderPayment();
            paypo_payment.setAmount(Integer.valueOf(gen_ord.getOrder_discount().replace(".", "")));
            paypo_payment.setType("discount");
            paypo_payment_list.add(paypo_payment);
        }
        return paypo_payment_list;
    }

    private List<com.paypo.bean.OrderItem> getOrderItems(GeneralOrder gen_ord) throws FrsvisionException {
        LinkedList<com.paypo.bean.OrderItem> paypo_item_list = new LinkedList<com.paypo.bean.OrderItem>();
        LinkedList<OrderItemVariation> paypo_var_list = new LinkedList<OrderItemVariation>();
        String item_code = "";
        String item_type = "";
        OrderItemVariation paypo_topping = new OrderItemVariation();
        for (OrderItem itm : gen_ord.getOrder_items()) {
            com.paypo.bean.OrderItem paypo_item = new com.paypo.bean.OrderItem();
            item_code = itm.getItem_pos_id();
            item_type = "";
            int itm_lvl = itm.getItem_level();
            try {
                paypo_item.setId(Integer.valueOf(itm.getItem_pos_id()));
                paypo_item.setName(itm.getItem_name());
                paypo_item.setPrice(Integer.valueOf(itm.getItem_price().replace(".", "")));
                paypo_item.setQuantity(Integer.valueOf(itm.getItem_qty()));
                paypo_item.setRemarks(itm.getItem_comment());
                if (itm_lvl > 0) {
                    paypo_topping.getItems().add(paypo_item);
                    continue;
                }
                if (!paypo_topping.getItems().isEmpty()) {
                    paypo_var_list.add(paypo_topping);
                    ((com.paypo.bean.OrderItem)paypo_item_list.get(paypo_item_list.size() - 1)).setVariations(paypo_var_list);
                    paypo_topping = new OrderItemVariation();
                    paypo_var_list = new LinkedList();
                }
                paypo_item_list.add(paypo_item);
            }
            catch (NumberFormatException ex) {
                throw new FrsvisionException(new Error(Error.ERROR_POS_MISSING_ITEM_NUMBER, "Pos item id isn't numeric " + itm.getItem_source_id() + "|" + itm.getItem_name()));
            }
        }
        if (!paypo_topping.getItems().isEmpty()) {
            paypo_var_list.add(paypo_topping);
            ((com.paypo.bean.OrderItem)paypo_item_list.get(paypo_item_list.size() - 1)).setVariations(paypo_var_list);
        }
        return paypo_item_list;
    }

    public PaypoOrder getPaypoOrder() {
        return this.paypoOrder;
    }

    public void setPaypoOrder(PaypoOrder paypoOrder) {
        this.paypoOrder = paypoOrder;
    }
}

