/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.genorder.bean.Address;
import com.genorder.bean.OrderContact;
import com.genorder.bean.OrderItem;
import com.genorder.bean.OrderLog;
import com.genorder.bean.OrderRestaurant;
import com.genorder.bean.OrderSource;
import com.genorder.bean.OrderStatus;
import com.genorder.bean.Payment;
import com.genorder.bean.PaymentCibus;
import com.genorder.bean.PaymentCreditCardDets;
import com.genorder.bean.RestPosParams;
import com.genorder.resources.GetOrderDetailtsEx;
import com.openrest.olo.charges.Charge;
import com.openrest.olo.charges.OrderCharge;
import com.openrest.olo.dispatches.DeliveryDispatch;
import com.openrest.order.beans.ItemDets;
import com.openrest.order.beans.OrderAndMenu;
import com.toorder.resources.DBConnector;
import com.toorder.resources.ToOrderFormatUtils;
import com.wix.pay.creditcard.CreditCard;
import com.wix.restaurants.i18n.Locale;
import com.wix.restaurants.payments.CibusPayment;
import com.wix.restaurants.payments.CreditcardPayment;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetSoOrderDetailtsEx
implements GetOrderDetailtsEx<OrderAndMenu> {
    @Override
    public String getOrderId() {
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        try {
            String order_id = dbc.execute("W $$^%W1SsID(\"SeferHaOchel\")", global_map);
            return order_id;
        }
        catch (Exception ex) {
            Logger.getLogger(GetSoOrderDetailtsEx.class.getName()).log(Level.SEVERE, null, ex);
            return "ERR-GET-ORDER-ID";
        }
    }

    @Override
    public Address getOrderAddress(OrderAndMenu om) {
        String city = "TAW";
        String neightbourhood = "";
        String street = "";
        String hous_num = "";
        String entrance = "";
        String floor = "";
        String appartment = "";
        String addr_comment = "";
        Double gps_geo_lat = 0.0;
        Double gps_geo_lng = 0.0;
        if (om.getOrder().delivery instanceof DeliveryDispatch) {
            DeliveryDispatch odlv = (DeliveryDispatch)om.getOrder().delivery;
            city = ToOrderFormatUtils.frmString(odlv.address.city);
            neightbourhood = "";
            street = ToOrderFormatUtils.frmString(odlv.address.street);
            hous_num = ToOrderFormatUtils.frmString(odlv.address.number);
            entrance = ToOrderFormatUtils.frmString(odlv.address.entrance);
            floor = ToOrderFormatUtils.frmString(odlv.address.floor);
            appartment = ToOrderFormatUtils.frmString(odlv.address.apt);
            String onArriveComment = "";
            if ("phone".equals(odlv.address.onArrival)) {
                onArriveComment = "\u05d1\u05d4\u05d2\u05e2\u05d4  \u05d4\u05ea\u05e7\u05e9\u05e8\u05d5 \u05d0\u05dc\u05d9";
            } else if ("buzz".equals(odlv.address.onArrival)) {
                onArriveComment = "\u05d1\u05d4\u05d2\u05e2\u05d4 \u05dc\u05e6\u05dc\u05e6\u05dc \u05d1\u05d3\u05dc\u05ea   ";
            }
            addr_comment = ToOrderFormatUtils.frmString(odlv.address.comment) + " , " + ToOrderFormatUtils.frmString(onArriveComment);
            gps_geo_lat = odlv.address.latLng.lat;
            gps_geo_lng = odlv.address.latLng.lng;
        }
        return new Address(city, neightbourhood, street, hous_num, entrance, floor, appartment, addr_comment, gps_geo_lat, gps_geo_lng);
    }

    @Override
    public Date getOrderDateDeliveryTime(OrderAndMenu om) {
        Date order_dlv_time = om.getOrder().delivery.time;
        return order_dlv_time;
    }

    @Override
    public List<OrderContact> getOrderContacts(OrderAndMenu om) {
        String contact_firstname = ToOrderFormatUtils.frmString(om.getOrder().contact.firstName);
        String contact_lastname = ToOrderFormatUtils.frmString(om.getOrder().contact.lastName);
        String contact_phone = ToOrderFormatUtils.frmPhone(om.getOrder().contact.phone);
        String contact_cellphone = ToOrderFormatUtils.frmPhone(om.getOrder().contact.phone);
        String contact_email = ToOrderFormatUtils.frmString(om.getOrder().contact.email);
        String contact_fax = ToOrderFormatUtils.frmPhone(om.getOrder().contact.fax);
        String contact_id = "";
        OrderContact oc = new OrderContact(contact_firstname, contact_lastname, contact_phone, contact_cellphone, contact_email, contact_fax, contact_id);
        LinkedList<OrderContact> ord_contact_list = new LinkedList<OrderContact>();
        ord_contact_list.add(oc);
        return ord_contact_list;
    }

    @Override
    public List<OrderItem> getOrderItems(OrderAndMenu om, Locale lang, String posId) {
        LinkedList<OrderItem> gen_order_items = new LinkedList<OrderItem>();
        int item_poz = 0;
        for (com.openrest.v1_1.OrderItem oi : om.getOrder().orderItems) {
            ++item_poz;
            ItemDets iDets = new ItemDets().setItemDetails(oi, om.getMenu(), lang, posId);
            String itemID = ToOrderFormatUtils.frmString(iDets.getItemId());
            String itemPosID = ToOrderFormatUtils.frmString(iDets.getItemPosID());
            String itemName = ToOrderFormatUtils.frmString(iDets.getItemName());
            String itemPrice = iDets.getItemPrice();
            String itemComment = ToOrderFormatUtils.frmString(iDets.getItemComment());
            String itemQty = "1.00";
            String itemDiscount = "0.00";
            String itemTotal = itemPrice;
            OrderItem gen_order_item = new OrderItem(item_poz, 0, "", itemID, itemPosID, itemName, itemPrice, itemQty, itemDiscount, itemTotal, itemComment);
            gen_order_items.add(gen_order_item);
            for (List<com.openrest.v1_1.OrderItem> varChoices : oi.variationsChoices) {
                for (com.openrest.v1_1.OrderItem varChoice : varChoices) {
                    OrderItem gen_order_var;
                    ItemDets varDets = new ItemDets().setItemDetails(varChoice, om.getMenu(), lang, posId);
                    ++item_poz;
                    String varId = ToOrderFormatUtils.frmString(varDets.getItemId());
                    String varPosID = ToOrderFormatUtils.frmString(varDets.getItemPosID());
                    String varName = ToOrderFormatUtils.frmString(varDets.getItemName());
                    String varPrice = varDets.getItemPrice();
                    String varComment = ToOrderFormatUtils.frmString(varDets.getItemComment());
                    String varQty = "1.00";
                    String varDiscount = "0.00";
                    String varTotal = varPrice;
                    if (itemPosID.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) {
                        varComment = varComment + " ";
                        varComment = varComment + itemComment;
                        itemComment = "";
                        gen_order_var = new OrderItem(item_poz, 0, "", varId, varPosID, varName, varPrice, varQty, varDiscount, varTotal, varComment);
                        gen_order_items.add(gen_order_var);
                    } else {
                        gen_order_var = new OrderItem(item_poz, 1, "V", varId, varPosID, varName, varPrice, varQty, varDiscount, varTotal, varComment);
                        gen_order_items.add(gen_order_var);
                    }
                    for (List<com.openrest.v1_1.OrderItem> varOfvarChoices : varChoice.variationsChoices) {
                        for (com.openrest.v1_1.OrderItem varOfvarChoice : varOfvarChoices) {
                            OrderItem gen_order_var_of_var;
                            ItemDets varOfvarDets = new ItemDets().setItemDetails(varOfvarChoice, om.getMenu(), lang, posId);
                            ++item_poz;
                            String varOfvarId = ToOrderFormatUtils.frmString(varOfvarDets.getItemId());
                            String varOfvarPosID = ToOrderFormatUtils.frmString(varOfvarDets.getItemPosID());
                            String varOfvarName = ToOrderFormatUtils.frmString(varOfvarDets.getItemName());
                            String varOfvarPrice = varOfvarDets.getItemPrice();
                            String varOfvarComment = ToOrderFormatUtils.frmString(varOfvarDets.getItemComment());
                            String varOfvarQty = "1.00";
                            String varOfvarDiscount = "0.00";
                            String varOfvarTotal = varOfvarPrice;
                            if (itemPosID.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) {
                                gen_order_var_of_var = new OrderItem(item_poz, 1, "V", varOfvarId, varOfvarPosID, varOfvarName, varOfvarPrice, varOfvarQty, varOfvarDiscount, varOfvarTotal, varOfvarComment);
                                gen_order_items.add(gen_order_var_of_var);
                            } else {
                                gen_order_var_of_var = new OrderItem(item_poz, 2, "VOV", varOfvarId, varOfvarPosID, varOfvarName, varOfvarPrice, varOfvarQty, varOfvarDiscount, varOfvarTotal, varOfvarComment);
                                gen_order_items.add(gen_order_var_of_var);
                            }
                            for (List<com.openrest.v1_1.OrderItem> lvl4Choices : varOfvarChoice.variationsChoices) {
                                for (com.openrest.v1_1.OrderItem lvl4Choice : lvl4Choices) {
                                    ItemDets lvl4varDets = new ItemDets().setItemDetails(lvl4Choice, om.getMenu(), lang, posId);
                                    ++item_poz;
                                    String lvl4varId = ToOrderFormatUtils.frmString(lvl4varDets.getItemId());
                                    String lvl4varPosID = ToOrderFormatUtils.frmString(lvl4varDets.getItemPosID());
                                    String lvl4varName = ToOrderFormatUtils.frmString(lvl4varDets.getItemName());
                                    String lvl4varPrice = lvl4varDets.getItemPrice();
                                    String lvl4varComment = ToOrderFormatUtils.frmString(lvl4varDets.getItemComment());
                                    String lvl4varQty = "1.00";
                                    String lvl4varDiscount = "0.00";
                                    String lvl4varTotal = lvl4varPrice;
                                    OrderItem gen_orderlvl4Var = new OrderItem(item_poz, 3, "VOV", lvl4varId, lvl4varPosID, lvl4varName, lvl4varPrice, lvl4varQty, lvl4varDiscount, lvl4varTotal, lvl4varComment);
                                    gen_order_items.add(gen_orderlvl4Var);
                                }
                            }
                        }
                    }
                }
            }
        }
        return gen_order_items;
    }

    @Override
    public OrderLog getOrderLog(OrderAndMenu om) {
        return new OrderLog();
    }

    @Override
    public OrderRestaurant getOrderRestaurant(OrderAndMenu om) throws Exception {
        String rest_source_id = ToOrderFormatUtils.frmString(om.getOrder().restaurantId);
        String rest_local_id = this.getToOrderRestCode(rest_source_id);
        return new OrderRestaurant(rest_source_id, rest_local_id, rest_source_id);
    }

    @Override
    public String getToOrderRestCode(String SourceRestCod) throws Exception {
        String resp = "";
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        resp = dbc.execute("W $G(^[$$^W3MAIN]W3SOR2M(\"" + SourceRestCod + "\")) ", global_map);
        if (resp.equals("[]")) {
            throw new Exception("Restaurant not connected to POS DB");
        }
        return resp;
    }

    @Override
    public OrderSource getOrderSource(OrderAndMenu om) {
        return new OrderSource(15, "SeferHaOhel", om.getOrder().id);
    }

    @Override
    public OrderStatus getOrderStatus(OrderAndMenu om) {
        return new OrderStatus(1, "", "", "", "");
    }

    @Override
    public List<Payment> getOrderPayment(OrderAndMenu om, String posId) {
        LinkedList<Payment> gen_order_payment = new LinkedList<Payment>();
        for (com.wix.restaurants.payments.Payment pay : om.getOrder().payments) {
            String amount = ToOrderFormatUtils.frmAgorotToNis(pay.amount.toString());
            Payment gen_order_paytrn = new Payment();
            if (pay instanceof CreditcardPayment) {
                CreditcardPayment paycrd = new CreditcardPayment();
                paycrd = (CreditcardPayment)pay;
                CreditCard cc_dets = om.getCards().get(paycrd.cardToken.token());
                String cc_card_type = ToOrderFormatUtils.frmString("");
                String cc_number = "";
                String cc_owner_id = "";
                String cc_cvv = "";
                String cc_owner_name = "";
                String cc_owner_phone = "";
                if (cc_dets != null) {
                    cc_number = ToOrderFormatUtils.frmString(cc_dets.number());
                    if (cc_dets.additionalFields().get().csc().isDefined()) {
                        cc_cvv = ToOrderFormatUtils.frmString(cc_dets.additionalFields().get().csc().get());
                    }
                    if (cc_dets.additionalFields().get().publicFields().get().holderId().isDefined()) {
                        cc_owner_id = ToOrderFormatUtils.frmString(cc_dets.additionalFields().get().publicFields().get().holderId().get());
                    }
                    if (cc_dets.additionalFields().get().publicFields().get().holderName().isDefined()) {
                        cc_owner_name = ToOrderFormatUtils.frmString(cc_dets.additionalFields().get().publicFields().get().holderName().get());
                    }
                } else if (paycrd.cardToken.creditCard().additionalFields().isDefined()) {
                    if (paycrd.cardToken.creditCard().additionalFields().get().holderId().isDefined()) {
                        cc_owner_id = ToOrderFormatUtils.frmString(paycrd.cardToken.creditCard().additionalFields().get().holderId().get());
                    }
                    if (paycrd.cardToken.creditCard().additionalFields().get().holderName().isDefined()) {
                        cc_owner_name = ToOrderFormatUtils.frmString(paycrd.cardToken.creditCard().additionalFields().get().holderName().get());
                    }
                }
                String cc_mounth = String.valueOf(paycrd.cardToken.creditCard().expiration().month());
                cc_mounth = String.format("%2s", cc_mounth).replace(' ', '0');
                String cc_year = String.valueOf(paycrd.cardToken.creditCard().expiration().year());
                String cc_exp = cc_mounth + "/" + cc_year.substring(2);
                PaymentCreditCardDets gen_order_credit = new PaymentCreditCardDets(cc_card_type, cc_number, cc_exp, cc_cvv, cc_owner_name, cc_owner_id, cc_owner_phone);
                gen_order_paytrn.setAmount(amount);
                gen_order_paytrn.setPayment_id(3);
                gen_order_paytrn.setPayment_type("CreditCard");
                gen_order_paytrn.setPayment_card_dets(gen_order_credit);
                gen_order_payment.add(gen_order_paytrn);
                continue;
            }
            if (pay instanceof CibusPayment) {
                PaymentCibus paycibus = new PaymentCibus(5, "Cibus", amount);
                gen_order_payment.add(paycibus);
                continue;
            }
            gen_order_paytrn.setAmount(amount);
            gen_order_paytrn.setPayment_id(1);
            gen_order_paytrn.setPayment_type("Cash");
            gen_order_payment.add(gen_order_paytrn);
        }
        return gen_order_payment;
    }

    @Override
    public String getOrderDeliveryFee(OrderAndMenu om) {
        String dlvfee = ToOrderFormatUtils.frmAgorotToNis(om.getOrder().delivery.charge.toString());
        return dlvfee;
    }

    @Override
    public String getOrderTip(OrderAndMenu om) {
        int totalCharges = 0;
        HashMap<String, Charge> chargesMap = new HashMap<String, Charge>();
        for (Charge charge : om.getMenu().chargesV2) {
            chargesMap.put(charge.id, charge);
        }
        int totalTip = 0;
        for (OrderCharge orderCharge : om.getOrder().orderCharges) {
            Charge charge = (Charge)chargesMap.get(orderCharge.chargeId);
            switch (charge.type) {
                case "tip": {
                    totalTip += orderCharge.amount.intValue();
                    break;
                }
                case "discount": {
                    totalCharges += orderCharge.amount.intValue();
                    break;
                }
            }
        }
        return "";
    }

    @Override
    public String getOrderDiscount(OrderAndMenu om) {
        String order_discount = ToOrderFormatUtils.frmIntToDecimal(null);
        if (om.getOrder().orderCharges == null) {
            return order_discount;
        }
        int i = 0;
        for (OrderCharge ch : om.getOrder().orderCharges) {
            i += ch.amount.intValue();
        }
        order_discount = ToOrderFormatUtils.frmAgorotToNis(Integer.toString(i *= -1));
        return order_discount;
    }

    @Override
    public String getOrderTotal(OrderAndMenu om) {
        String total = ToOrderFormatUtils.frmAgorotToNis(om.getOrder().price.toString());
        return total;
    }

    @Override
    public String getOrderComment(OrderAndMenu om) {
        String order_comment = ToOrderFormatUtils.frmString(om.getOrder().comment);
        return order_comment;
    }

    @Override
    public RestPosParams getRestPosParams(OrderAndMenu om) {
        return new RestPosParams();
    }

    @Override
    public int getNumOfDinners(OrderAndMenu om) {
        int takeoutPack = om.getOrder().takeoutPacks == null ? 0 : om.getOrder().takeoutPacks;
        return takeoutPack;
    }
}

