/*
 * Decompiled with CFR 0.152.
 */
package com.genorder.resources;

import com.genorder.bean.Address;
import com.genorder.bean.OrderContact;
import com.genorder.bean.OrderItem;
import com.genorder.bean.OrderLog;
import com.genorder.bean.OrderRestaurant;
import com.genorder.bean.OrderSource;
import com.genorder.bean.OrderStatus;
import com.genorder.bean.Payment;
import com.genorder.bean.PaymentCibus;
import com.genorder.bean.PaymentCreditCardDets;
import com.genorder.bean.RestPosParams;
import com.genorder.resources.GetOrderDetailtsExV3;
import com.openrest.order.beans.SoMenuMap;
import com.openrest.order.beans.v3.DishOption;
import com.openrest.order.beans.v3.Entity;
import com.openrest.order.beans.v3.Fulfillment;
import com.openrest.order.beans.v3.ItemDetsV3;
import com.openrest.order.beans.v3.LineItem;
import com.openrest.order.beans.v3.SelectedChoices;
import com.toorder.resources.ToOrderFormatUtils;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class GetSoOrderDetailtsExV3
implements GetOrderDetailtsExV3<Entity> {
    @Override
    public String getOrderId() {
        return "";
    }

    @Override
    public Address getOrderAddress(Entity om) {
        String city = "TAW";
        String neightbourhood = "";
        String street = "";
        String hous_num = "";
        String entrance = "";
        String floor = "";
        String appartment = "";
        String addr_comment = "";
        Double gps_geo_lat = 0.0;
        Double gps_geo_lng = 0.0;
        Fulfillment odlv = om.getFulfillment();
        if (odlv.getType().contains("DELIVERY")) {
            city = ToOrderFormatUtils.frmString(odlv.getDeliveryDetails().getAddress().getCity());
            neightbourhood = "";
            street = ToOrderFormatUtils.frmString(odlv.getDeliveryDetails().getAddress().getStreet());
            hous_num = ToOrderFormatUtils.frmString(odlv.getDeliveryDetails().getAddress().getStreetNumber());
            entrance = ToOrderFormatUtils.frmString(odlv.getDeliveryDetails().getAddress().getEntrance());
            floor = ToOrderFormatUtils.frmString(odlv.getDeliveryDetails().getAddress().getFloor());
            appartment = ToOrderFormatUtils.frmString(odlv.getDeliveryDetails().getAddress().getApt());
            String onArriveComment = "";
            if ("CALL_ME".equals(odlv.getDeliveryDetails().getAddress().getOnArrival())) {
                onArriveComment = "";
            } else if ("BUZZ_DOOR".equals(odlv.getDeliveryDetails().getAddress().getOnArrival())) {
                onArriveComment = "   ";
            }
            addr_comment = ToOrderFormatUtils.frmString(odlv.getDeliveryDetails().getAddress().getComment()) + " , " + ToOrderFormatUtils.frmString(onArriveComment);
        }
        return new Address(city, neightbourhood, street, hous_num, entrance, floor, appartment, addr_comment, gps_geo_lat, gps_geo_lng);
    }

    @Override
    public Date getOrderDateDeliveryTime(Entity om) {
        Date order_dlv_time = om.getFulfillment().getPromisedTime();
        return order_dlv_time;
    }

    @Override
    public List<OrderContact> getOrderContacts(Entity om) {
        String contact_firstname = ToOrderFormatUtils.frmString(om.getCustomer().getFirstName());
        String contact_lastname = ToOrderFormatUtils.frmString(om.getCustomer().getLastName());
        String contact_phone = ToOrderFormatUtils.frmPhone(om.getCustomer().getPhone());
        String contact_cellphone = ToOrderFormatUtils.frmPhone(om.getCustomer().getPhone());
        String contact_email = ToOrderFormatUtils.frmString(om.getCustomer().getEmail());
        String contact_fax = ToOrderFormatUtils.frmPhone(om.getCustomer().getPhone());
        String contact_id = "";
        OrderContact oc = new OrderContact(contact_firstname, contact_lastname, contact_phone, contact_cellphone, contact_email, contact_fax, contact_id);
        LinkedList<OrderContact> ord_contact_list = new LinkedList<OrderContact>();
        ord_contact_list.add(oc);
        return ord_contact_list;
    }

    @Override
    public List<OrderItem> getOrderItemsV3(Entity om, SoMenuMap somm) {
        LinkedList<OrderItem> gen_order_items = new LinkedList<OrderItem>();
        int item_poz = 0;
        for (LineItem oi : om.getLineItems()) {
            ++item_poz;
            ItemDetsV3 iDets = new ItemDetsV3().setItemDetails(oi, somm);
            String itemID = ToOrderFormatUtils.frmString(oi.getCatalogReference().getCatalogItemId());
            String itemPosID = ToOrderFormatUtils.frmString(iDets.getItemPosID());
            String itemName = ToOrderFormatUtils.frmString(iDets.getItemName());
            String itemPrice = iDets.getItemPrice();
            String itemComment = ToOrderFormatUtils.frmString(iDets.getItemComment());
            String itemQty = iDets.getItemQty().toString();
            String itemDiscount = "0.00";
            String itemTotal = itemPrice;
            if (!itemPosID.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) {
                OrderItem gen_order_item = new OrderItem(item_poz, 0, "", itemID, itemPosID, itemName, itemPrice, itemQty, itemDiscount, itemTotal, itemComment);
                gen_order_items.add(gen_order_item);
            } else {
                --item_poz;
            }
            for (DishOption dishOpt : oi.getDishOptions()) {
                for (SelectedChoices selOpt : dishOpt.getSelectedChoices()) {
                    OrderItem gen_order_var;
                    ItemDetsV3 varDets = new ItemDetsV3().setItemDetails(selOpt, somm);
                    ++item_poz;
                    String varId = ToOrderFormatUtils.frmString(varDets.getItemId());
                    String varPosID = ToOrderFormatUtils.frmString(varDets.getItemPosID());
                    String varName = ToOrderFormatUtils.frmString(varDets.getItemName());
                    String varPrice = varDets.getItemPrice();
                    String varComment = ToOrderFormatUtils.frmString(varDets.getItemComment());
                    String varQty = iDets.getItemQty().toString();
                    String varDiscount = "0.00";
                    String varTotal = varPrice;
                    if (itemPosID.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) {
                        varComment = varComment + " ";
                        varComment = varComment + itemComment;
                        itemComment = "";
                        varQty = itemQty;
                        gen_order_var = new OrderItem(item_poz, 0, "", varId, varPosID, varName, varPrice, varQty, varDiscount, varTotal, varComment);
                        gen_order_items.add(gen_order_var);
                    } else {
                        gen_order_var = new OrderItem(item_poz, 1, "V", varId, varPosID, varName, varPrice, varQty, varDiscount, varTotal, varComment);
                        gen_order_items.add(gen_order_var);
                    }
                    for (DishOption selOptOfdishOpt : selOpt.getDishOptions()) {
                        for (SelectedChoices selOptOfOpt : selOptOfdishOpt.getSelectedChoices()) {
                            OrderItem gen_order_var_of_var;
                            ItemDetsV3 varOfvarDets = new ItemDetsV3().setItemDetails(selOptOfOpt, somm);
                            String varOfvarId = ToOrderFormatUtils.frmString(varOfvarDets.getItemId());
                            String varOfvarPosID = ToOrderFormatUtils.frmString(varOfvarDets.getItemPosID());
                            String varOfvarName = ToOrderFormatUtils.frmString(varOfvarDets.getItemName());
                            String varOfvarPrice = varOfvarDets.getItemPrice();
                            String varOfvarComment = ToOrderFormatUtils.frmString(varOfvarDets.getItemComment());
                            String varOfvarQty = iDets.getItemQty().toString();
                            String varOfvarDiscount = "0.00";
                            String varOfvarTotal = varOfvarPrice;
                            if (itemPosID.contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) {
                                gen_order_var_of_var = new OrderItem(item_poz, 1, "V", varOfvarId, varOfvarPosID, varOfvarName, varOfvarPrice, varOfvarQty, varOfvarDiscount, varOfvarTotal, varOfvarComment);
                                gen_order_items.add(gen_order_var_of_var);
                                continue;
                            }
                            gen_order_var_of_var = new OrderItem(item_poz, 2, "VOV", varOfvarId, varOfvarPosID, varOfvarName, varOfvarPrice, varOfvarQty, varOfvarDiscount, varOfvarTotal, varOfvarComment);
                            gen_order_items.add(gen_order_var_of_var);
                        }
                    }
                }
            }
        }
        return gen_order_items;
    }

    @Override
    public OrderLog getOrderLog(Entity om) {
        return new OrderLog();
    }

    @Override
    public OrderRestaurant getOrderRestaurant(Entity om) throws Exception {
        String rest_source_id = om.getRestaurantId();
        String rest_local_id = "";
        return new OrderRestaurant(rest_source_id, rest_local_id, rest_source_id);
    }

    @Override
    public String getToOrderRestCode(String SourceRestCod) throws Exception {
        return "";
    }

    @Override
    public OrderSource getOrderSource(Entity om) {
        return new OrderSource(15, "SeferHaOhel", om.getId());
    }

    @Override
    public OrderStatus getOrderStatus(Entity om) {
        return new OrderStatus(1, "", "", "", "");
    }

    public LinkedList<Payment> getOrderPayment(Entity om) {
        LinkedList<Payment> gen_order_payment = new LinkedList<Payment>();
        for (com.openrest.order.beans.v3.Payment pay : om.getPayments()) {
            String amount = pay.getAmount();
            Payment gen_order_paytrn = new Payment();
            if (pay.getMethod().equalsIgnoreCase("creditCard")) {
                Object cc_dets = null;
                String cc_card_type = ToOrderFormatUtils.frmString("1");
                String cc_number = "";
                String cc_owner_id = "";
                String cc_cvv = "";
                String cc_owner_name = "";
                String cc_owner_phone = "";
                String cc_exp = "00/00";
                PaymentCreditCardDets gen_order_credit = new PaymentCreditCardDets(cc_card_type, cc_number, cc_exp, cc_cvv, cc_owner_name, cc_owner_id, cc_owner_phone);
                gen_order_paytrn.setAmount(amount);
                gen_order_paytrn.setPayment_id(3);
                gen_order_paytrn.setPayment_type("CreditCard");
                gen_order_paytrn.setPayment_card_dets(gen_order_credit);
                gen_order_payment.add(gen_order_paytrn);
                continue;
            }
            if ("CIBUS".equalsIgnoreCase(pay.getType())) {
                PaymentCibus paycibus = new PaymentCibus(5, "Cibus", amount);
                gen_order_payment.add(paycibus);
                continue;
            }
            gen_order_paytrn.setAmount(amount);
            gen_order_paytrn.setPayment_id(1);
            gen_order_paytrn.setPayment_type("Cash");
            gen_order_payment.add(gen_order_paytrn);
        }
        return gen_order_payment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOrderDeliveryFee(Entity om) {
        String dlvfee = "0.0";
        try {
            dlvfee = om.getTotals().getDelivery();
            return dlvfee;
        }
        catch (Exception e) {
            dlvfee = "0.0";
            return dlvfee;
        }
        finally {
            if (dlvfee == null) {
                dlvfee = "0.0";
            }
            return dlvfee;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOrderTip(Entity om) {
        String tip = "";
        try {
            tip = om.getTotals().getTip();
            return tip;
        }
        catch (Exception exception) {}
        finally {
            if (tip == null) {
                tip = "0.0";
            }
            return tip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOrderDiscount(Entity om) {
        String disc = "0";
        try {
            disc = om.getTotals().getDiscount();
            return disc;
        }
        catch (Exception e) {
            disc = "0";
            return disc;
        }
        finally {
            if (disc == null) {
                disc = "0.0";
            }
            return disc;
        }
    }

    @Override
    public String getOrderTotal(Entity om) {
        String total = om.getTotals().getTotal();
        return total;
    }

    @Override
    public String getOrderComment(Entity om) {
        String order_comment = ToOrderFormatUtils.frmString(om.getComment());
        return order_comment;
    }

    @Override
    public RestPosParams getRestPosParams(Entity om) {
        return new RestPosParams();
    }

    @Override
    public int getNumOfDinners(Entity om) {
        int takeoutPack = 0;
        return takeoutPack;
    }
}

