/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.olo.dispatches;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.openrest.olo.dispatches.DeliveryDispatch;
import com.openrest.olo.dispatches.PickupDispatch;
import com.openrest.olo.dispatches.PremisesDispatch;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PickupDispatch.class, name="takeout"), @JsonSubTypes.Type(value=DeliveryDispatch.class, name="delivery"), @JsonSubTypes.Type(value=PremisesDispatch.class, name="premises")})
public abstract class Dispatch
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Date time;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String timeGuarantee = "before";
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer charge = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();

    public Dispatch() {
    }

    public Dispatch(Date time, String timeGuarantee, Integer charge, Map<String, String> properties) {
        this.time = time;
        this.timeGuarantee = timeGuarantee;
        this.charge = charge;
        this.properties = properties;
    }

    public Dispatch clone() {
        return this.cloneImpl();
    }

    protected abstract Dispatch cloneImpl();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dispatch dispatch = (Dispatch)o;
        return Objects.equals(this.time, dispatch.time) && Objects.equals(this.timeGuarantee, dispatch.timeGuarantee) && Objects.equals(this.charge, dispatch.charge) && Objects.equals(this.properties, dispatch.properties);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.timeGuarantee, this.charge, this.properties);
    }
}

