/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.resources;

import com.beecom.bean.BeecomTokenResp;
import com.beecom.bean.PushOrderRequest;
import com.beecom.bean.PushOrderResp;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.frsvision.bean.GenericType;
import com.frsvision.bean.ObjectFactory;
import com.frsvision.resources.net.DirectSocketsClient;
import com.frsvision.resources.net.FrsvisionProtocol;
import com.frsvision.resources.net.SocketsClientException;
import com.frsvision.resources.pos.Error;
import com.frsvision.resources.pos.FrsvisionException;
import com.frsvision.resources.pos.Response;
import com.genorder.bean.OrderItem;
import com.genorder.bean.RestPosParams;
import com.genorder.resources.ConvertGeneralToFrsOrderV3;
import com.genorder.resources.ConvertGeneralToPrestoOrderV3;
import com.genorder.resources.ConvertGeneralV3ToPaypoOrder;
import com.genorder.resources.ConvertSoV3ToBeecomOrder;
import com.openrest.order.beans.v3.Data;
import com.openrest.resources.ConvertSoV3OrderToGeneralOrder;
import com.openrest.resources.HttpCl;
import com.openrest.resources.ResponseToSo;
import com.paypo.bean.PaypoOrder;
import com.presto.resources.SendFileToFtpServer;
import com.utils.TLSEmail;
import com.wix.restaurants.json.Json;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import okhttp3.ResponseBody;
import org.apache.commons.codec.binary.Base64;
import scala.Option;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ProcessSoOrderV3 {
    void processOrder(Data data, String restId, String orderId) throws Exception {
        ObjectMapper om1 = new ObjectMapper();
        File restparamsfl = new File("/pos/tmp/cfg/restparams_" + restId);
        if (restparamsfl.exists()) {
            String restParam = new String(Files.readAllBytes(restparamsfl.toPath()), StandardCharsets.UTF_8);
            RestPosParams restPosParams = Json.parse(restParam, RestPosParams.class);
            if (restPosParams.getPosType().contains("elpos") || restPosParams.getPosType().contains("ipos")) {
                ConvertSoV3OrderToGeneralOrder conv_to_gen_order = new ConvertSoV3OrderToGeneralOrder();
                conv_to_gen_order.setPosType(restPosParams.getPosType());
                conv_to_gen_order.ConvertSOExToGeneralOrder(data);
                conv_to_gen_order.getGord().getOrder_rest().setRest_local_id(restPosParams.getRest_Id());
                System.out.printf("\nConverting elpos/ipos order : %s from restaurnt : %s ", orderId, restId);
                ObjectMapper om = new ObjectMapper();
                HttpCl httpcl = new HttpCl();
                System.out.printf("\nSending  elpos/ipos order : %s from restaurnt : %s ", orderId, restId);
                String genorder = om.writeValueAsString(conv_to_gen_order.getGord());
                String rsp = httpcl.post("https://2order.org/api/restgenord/SaveOrder", genorder);
                System.out.printf("\nResult %s  elpos/ipos  order : %s from restaurnt : %s ", rsp, orderId, restId);
            } else if (restPosParams.getPosType().contains("beecom")) {
                ConvertSoV3ToBeecomOrder beecomorder = new ConvertSoV3ToBeecomOrder();
                beecomorder.setPosType(restPosParams.getPosType());
                System.out.printf("\nConverting beecom order : %s from restaurnt : %s ", orderId, restId);
                beecomorder.ConvertSOExToGeneralOrder(data);
                System.out.printf("\nSending  beecom  order : %s from restaurnt : %s ", orderId, restId);
                String resp = this.sendBeecomOrder(beecomorder, restPosParams.getBranchID());
                System.out.printf("\nResult %s  Beecom  order : %s from restaurnt : %s ", resp, orderId, restId);
            } else if (restPosParams.getPosType().contains("presto")) {
                ConvertGeneralToPrestoOrderV3 conv_gen_to_presto = new ConvertGeneralToPrestoOrderV3();
                conv_gen_to_presto.setPosType(restPosParams.getPosType());
                System.out.printf("\nConverting presto order : %s from restaurnt : %s ", orderId, restId);
                conv_gen_to_presto.ConvertSOExToGeneralOrder(data);
                conv_gen_to_presto.getPrestoParams().setCosticket(restPosParams.getCostiket());
                conv_gen_to_presto.getPrestoParams().setCrediticket(restPosParams.getCredittiket());
                conv_gen_to_presto.getPrestoParams().setWorker(Integer.valueOf(restPosParams.getWorker()));
                conv_gen_to_presto.ConvertGenToPrestoOrder();
                System.out.printf("\nSending  presto  order : %s from restaurnt : %s ", orderId, restId);
                String prestoResp = this.sendPrestoOrder(conv_gen_to_presto, restPosParams.getHost(), restPosParams.getPort());
                System.out.printf("\nResult %s  Presto  order : %s from restaurnt : %s ", prestoResp, orderId, restId);
            } else if (restPosParams.getPosType().contains("frs")) {
                System.out.printf("\nconverting frs order : %s from restaurnt : %s ", orderId, restId);
                ConvertGeneralToFrsOrderV3 conv_tofrs = new ConvertGeneralToFrsOrderV3();
                conv_tofrs.setPosType(restPosParams.getPosType());
                conv_tofrs.ConvertSOExToGeneralOrder(data);
                conv_tofrs.ConvertGenToFrsOrder(restPosParams.getStatus());
                String tip = conv_tofrs.getGord().getOrder_tip();
                if (!tip.equals("0.00")) {
                    String tipId = restPosParams.getTipID();
                    OrderItem tipItem = new OrderItem(conv_tofrs.getGord().getOrder_items().size(), 0, "", "0", tipId, "", tip, "1", "0", tip, "TIP");
                    conv_tofrs.getGord().getOrder_items().add(tipItem);
                }
                System.out.printf("\nSending  frs  order : %s from restaurnt : %s ", orderId, restId);
                String resp = this.sendFrsOrder(conv_tofrs, restPosParams.getHost(), restPosParams.getPort());
                System.out.printf("\nResult %s  frs  order : %s from restaurnt : %s ", resp, orderId, restId);
            } else if (restPosParams.getPosType().contains("10bis")) {
                ConvertGeneralV3ToPaypoOrder paypoorder = new ConvertGeneralV3ToPaypoOrder();
                paypoorder.setPosType(restPosParams.getPosType());
                System.out.printf("\nConverting paypo order : %s from restaurnt : %s ", orderId, restId);
                paypoorder.ConvertSOExToGeneralOrder(data);
                System.out.printf("\nSending  paypo  order : %s from restaurnt : %s ", orderId, restId);
                String resp = this.sendPaypoOrder(paypoorder, Integer.valueOf(restPosParams.getBranchID()), "SeferOchel", Integer.valueOf(restPosParams.getWorker()), restPosParams.getRest_Id(), restPosParams.getHost());
                System.out.printf("\nResult %s  Paypo  order : %s from restaurnt : %s ", resp, orderId, restId);
            }
        } else {
            System.out.println("\n no rest params for  restaurant : " + restId);
        }
    }

    private String sendFrsOrder(ConvertGeneralToFrsOrderV3 conv_tofrs, String host, String port) {
        String logRec = "";
        String logGlobal = "^FRSLOG";
        String frsOrderFile = "/pos/tmp/frs/orderfrs" + port + "_" + conv_tofrs.getGord().getOrder_source().getSource_order_id() + ".xml";
        LinkedHashMap<String, String> respmessages = new LinkedHashMap<String, String>();
        long prepTmStart = System.currentTimeMillis();
        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dtlog = sdf.format(dt);
        StringWriter frsxml = new StringWriter();
        try {
            ResponseToSo resp;
            String orderid = conv_tofrs.getOrderId();
            logGlobal = logGlobal + "(" + "\"" + dtlog + "\"" + ",\"";
            logGlobal = logGlobal + port + "\"" + ",\"";
            logGlobal = logGlobal + orderid + "\"" + ")";
            long sendTimeStart = System.currentTimeMillis();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GenericType.class, ObjectFactory.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)conv_tofrs.getFrsOtrder(), new File(frsOrderFile));
            Marshaller jaxbMarshaller1 = jaxbContext.createMarshaller();
            jaxbMarshaller1.setProperty("jaxb.formatted.output", (Object)false);
            jaxbMarshaller1.marshal((Object)conv_tofrs.getFrsOtrder(), (Writer)frsxml);
            frsxml.flush();
            if (frsxml.toString().length() == 0) {
                throw new Exception("Xml generetad by marshal  is empty");
            }
            DirectSocketsClient sockets = new DirectSocketsClient(1024);
            String key = "Sites2013@";
            String iv = "AAAAAAAAAAAAAAAAAAAAAA==";
            byte[] decodediv = Base64.decodeBase64(iv.getBytes("UTF-8"));
            String decodedsrt = new String(decodediv, "UTF-8");
            FiniteDuration duration = Duration.create(25000L, TimeUnit.MILLISECONDS);
            Option<Duration> connectTimeout = Option.apply(duration);
            FrsvisionProtocol protocol = new FrsvisionProtocol(sockets, host, Integer.valueOf(port), key, decodedsrt, connectTimeout, connectTimeout, connectTimeout, connectTimeout);
            String res = protocol.send(frsxml.toString());
            Response frsresp = Response.parse(res);
            long sendTimeDuration = System.currentTimeMillis() - sendTimeStart;
            Error err = new Error(frsresp.getCode(), frsresp.getDescription());
            Integer rescod = Integer.valueOf(err.getCode());
            switch (rescod) {
                case 0: {
                    respmessages.put("orderId", err.getDescription());
                    resp = new ResponseToSo("value", respmessages);
                    break;
                }
                case 11: {
                    String frsorderid = err.getDescription().split(":")[1].trim();
                    respmessages.put("orderId", frsorderid);
                    resp = new ResponseToSo("value", respmessages);
                    break;
                }
                case 3: {
                    respmessages.put("code", "cc_rejected");
                    respmessages.put("description", "frs :" + err.getCode() + " : " + err.getDescription());
                    resp = new ResponseToSo("error", respmessages);
                    TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "Frs Error rest", resp.toString(), frsOrderFile);
                    break;
                }
                case 5: {
                    respmessages.put("code", "invalid_item_mapping");
                    respmessages.put("description", "frs :" + err.getCode() + " : " + err.getDescription());
                    resp = new ResponseToSo("error", respmessages);
                    TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "Error", resp.toString(), frsOrderFile);
                    break;
                }
                default: {
                    respmessages.put("code", "endpoint_down");
                    respmessages.put("description", "frs :" + err.getCode() + " : " + err.getDescription());
                    resp = new ResponseToSo("error", respmessages);
                    TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "Error", resp.toString(), frsOrderFile);
                }
            }
            long preptime = sendTimeStart - prepTmStart;
            logRec = logRec + "\"" + err.getCode() + "~" + err.getDescription() + "~" + String.valueOf(preptime) + "~" + String.valueOf(sendTimeDuration) + "\"";
            return resp.toString();
        }
        catch (SocketsClientException netex) {
            respmessages.put("code", "endpoint_down");
            respmessages.put("description", "Frs socket exception");
            ResponseToSo err = new ResponseToSo("error", respmessages);
            logRec = logRec + "\"" + "1" + "~" + "endpoint_down" + "~" + "" + "~" + "\"";
            logRec = logRec + "\"" + "1" + "~" + netex.getMessage() + "~" + "" + "~" + "\"";
            TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "Error", logRec, frsOrderFile);
            return err.toString();
        }
        catch (FrsvisionException frsex) {
            if (Error.ERROR_POS_MISSING_ITEM_NUMBER.equals(frsex.getError().getCode())) {
                respmessages.put("code", "invalid_item_mapping");
                logRec = logRec + "\"" + "1" + "~" + "invalid_item_mapping" + "~" + "" + "~" + "\"";
                logRec = logRec + "\"" + "1" + "~" + frsex.getError().toString() + "~" + "" + "~" + "\"";
                TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "Error", logRec, frsOrderFile);
            } else {
                respmessages.put("code", "endpoint_down");
                logRec = logRec + "\"" + "1" + "~" + "pos_error" + "~" + "" + "~" + "\"";
                logRec = logRec + "\"" + "1" + "~" + frsex.getError().toString() + "~" + "" + "~" + "\"";
                TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "Error", logRec, frsOrderFile);
            }
            respmessages.put("description", "frs :" + frsex.getError().toString());
            ResponseToSo err = new ResponseToSo("error", respmessages);
            return err.toString();
        }
        catch (Exception ex) {
            respmessages.put("code", "endpoint_down");
            respmessages.put("description", "Exception created");
            ResponseToSo err = new ResponseToSo("error", respmessages);
            logRec = logRec + "\"" + "1" + "~" + "exception error" + "~" + "" + "~" + "\"";
            logRec = logRec + "\"" + "1" + "~" + ex.getMessage() + "~" + "" + "~" + "\"";
            TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "Error", logRec, "");
            return err.toString();
        }
    }

    private String sendPrestoOrder(ConvertGeneralToPrestoOrderV3 conv_gen_to_presto, String host, String port) {
        String logRec = "";
        String logGlobal = "^PRESTOLOG";
        LinkedHashMap<String, String> respmessages = new LinkedHashMap<String, String>();
        long prepTmStart = System.currentTimeMillis();
        String ordid = conv_gen_to_presto.getGord().getOrder_source().getSource_order_id();
        String flname = ordid + ".bok";
        String prestoOrderFile = "/pos/tmp/presto/" + flname;
        try {
            long sendTimeStart = System.currentTimeMillis();
            String out1 = "";
            ObjectMapper om1 = new ObjectMapper();
            out1 = om1.writeValueAsString(conv_gen_to_presto.getPrestoOrder());
            om1 = null;
            if (host.length() == 0) {
                host = "82.80.41.234";
            }
            if ("".equals(port) || port.equals(null)) {
                port = "8825";
            }
            String username = "mis";
            String password = "12345678";
            SendFileToFtpServer sndtoftp = new SendFileToFtpServer(host, port, username, password);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(prestoOrderFile), "WINDOWS-1255"));
            bw.write(out1);
            bw.flush();
            bw.close();
            sndtoftp.sendFile(prestoOrderFile, flname);
            respmessages.put("orderId", "1");
            ResponseToSo resp = new ResponseToSo("value", respmessages);
            return resp.toString();
        }
        catch (IOException netex) {
            respmessages.put("code", "endpoint_down");
            respmessages.put("description", "presto connection error :ftp connection problem");
            ResponseToSo resp = new ResponseToSo("error", respmessages);
            TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "presto Error" + resp, logRec, prestoOrderFile);
            return resp.toString();
        }
        catch (Exception ex) {
            respmessages.put("code", "internal");
            respmessages.put("description", ex.toString());
            ResponseToSo resp = new ResponseToSo("error", respmessages);
            return resp.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendBeecomOrder(ConvertSoV3ToBeecomOrder conv_tobeccom, String branchId) {
        LinkedHashMap<String, String> respmessages = new LinkedHashMap<String, String>();
        ResponseToSo resp5 = new ResponseToSo();
        String resptag = "value";
        try {
            PushOrderRequest becomOrder = new PushOrderRequest();
            becomOrder.setBranchId(branchId);
            conv_tobeccom.ConvertGenToBeecomOrder();
            becomOrder.setOrderInfo(conv_tobeccom.getBeecomOrder());
            long sendTimeStart = System.currentTimeMillis();
            HttpCl httpcl = new HttpCl();
            BeecomTokenResp resp2 = new BeecomTokenResp();
            okhttp3.Response resp1 = httpcl.beecomform("https://biapp.beecomm.co.il:8094/v2/oauth/token");
            if (resp1.code() != 200) {
                System.out.println("Beecom Failed with HTTP error code : " + resp1.code());
            } else if (resp1.isSuccessful()) {
                resp2 = new ObjectMapper().readValue(resp1.body().string(), BeecomTokenResp.class);
                System.out.printf("getting beecom token %s", resp2.toString());
            }
            String beord = new ObjectMapper().writeValueAsString(becomOrder);
            okhttp3.Response resp3 = httpcl.post("https://biapp.beecomm.co.il:8094/api/v2/services/orderCenter/pushOrder", beord, resp2.getAccess_token());
            ResponseBody respbody = resp3.body();
            PushOrderResp resp4 = new PushOrderResp();
            if (resp3.code() != 200) {
                System.out.printf("Connection error from Beecom server %s for restaurant %s order id %s ", resp3.toString(), branchId, conv_tobeccom.getBeecomOrder().getOuterCompOrderId());
                throw new RuntimeException("Failed Conecting to Beecom server with  HTTP error code : " + resp3.code());
            }
            respmessages.put("orderId", "1");
            resp5.tag = resptag;
            resp5.respMessages = respmessages;
            System.out.println("");
        }
        catch (FrsvisionException frsex) {
            if (Error.ERROR_POS_MISSING_ITEM_NUMBER.equals(frsex.getError().getCode())) {
                respmessages.put("code", "invalid_item_mapping");
            }
            respmessages.put("code", "endpoint_down");
            respmessages.put("description", "beecom :" + frsex.getError().toString());
        }
        catch (Exception ex) {
            respmessages.put("code", "endpoint_down");
            respmessages.put("description", "exception error");
            resptag = "error";
            return resptag;
        }
        finally {
            resp5.tag = resptag;
            resp5.respMessages = respmessages;
            TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "BEECOM  Branch " + branchId, resp5.toString(), "");
            return resp5.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPaypoOrder(ConvertGeneralV3ToPaypoOrder conv_topaypo, int storeID, String providerName, int employeeID, String token, String urlPrefix) {
        String url = "https://" + urlPrefix + ".paypo.com/api/InsertOnlineOrdersAsync_V2";
        url = url + "?token=" + token + "&storeID=" + storeID + "&providerName=" + providerName + "&employeeID=" + employeeID;
        LinkedHashMap<String, String> respmessages = new LinkedHashMap<String, String>();
        ResponseToSo resp5 = new ResponseToSo();
        String resptag = "value";
        try {
            PaypoOrder paypoOrder = new PaypoOrder();
            conv_topaypo.convertGenToPaypoOrder();
            paypoOrder = conv_topaypo.getPaypoOrder();
            long sendTimeStart = System.currentTimeMillis();
            HttpCl httpcl = new HttpCl();
            String jsonOrd = new ObjectMapper().writeValueAsString(paypoOrder);
            String resp = httpcl.post(url, jsonOrd);
            if (!resp.contains("200")) {
                System.out.printf("Connection error from Paypo server %s for restaurant %s order id %s ", resp, storeID);
                throw new RuntimeException("Failed Conecting to Beecom server with  HTTP error code : " + resp);
            }
            respmessages.put("orderId", "1");
            resp5.tag = resptag;
            resp5.respMessages = respmessages;
            System.out.println("");
        }
        catch (FrsvisionException frsex) {
            if (Error.ERROR_POS_MISSING_ITEM_NUMBER.equals(frsex.getError().getCode())) {
                respmessages.put("code", "invalid_item_mapping");
            }
            respmessages.put("code", "endpoint_down");
            respmessages.put("description", "paypo :" + frsex.getError().toString());
        }
        catch (Exception ex) {
            respmessages.put("code", "endpoint_down");
            respmessages.put("description", "exception error");
            resptag = "error";
            return resptag;
        }
        finally {
            resp5.tag = resptag;
            resp5.respMessages = respmessages;
            TLSEmail.sendTSLEmail("info@damkasys.co.il", "19SpiDer76$", "food100@food.co.il", "PAYPO  Branch " + storeID, resp5.toString(), "");
            return resp5.toString();
        }
    }
}

