/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.openrest.v1_1.LatLng;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Address
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String formatted;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String country;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String city;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String street;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String number;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String apt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String floor;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String entrance;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String comment;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LatLng latLng;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean approximate = Boolean.FALSE;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String countryCode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String postalCode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String onArrival;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> externalIds = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();

    public Address(String formatted, String country, String city, String street, String number, String apt, String floor, String entrance, String comment, LatLng latLng, Boolean approximate, String countryCode, String postalCode, String onArrival, Map<String, String> externalIds, Map<String, String> properties) {
        this.formatted = formatted;
        this.country = country;
        this.city = city;
        this.street = street;
        this.number = number;
        this.apt = apt;
        this.floor = floor;
        this.entrance = entrance;
        this.comment = comment;
        this.latLng = latLng;
        this.approximate = approximate;
        this.countryCode = countryCode;
        this.postalCode = postalCode;
        this.onArrival = onArrival;
        this.externalIds = externalIds;
        this.properties = properties;
    }

    public Address() {
    }

    public Address clone() {
        return new Address(this.formatted, this.country, this.city, this.street, this.number, this.apt, this.floor, this.entrance, this.comment, this.latLng != null ? this.latLng.clone() : null, this.approximate, this.countryCode, this.postalCode, this.onArrival, this.externalIds != null ? new LinkedHashMap<String, String>(this.externalIds) : null, (Map<String, String>)(this.properties != null ? new LinkedHashMap<String, String>(this.properties) : null));
    }

    public static List<Address> clone(List<Address> addresses) {
        if (addresses == null) {
            return null;
        }
        LinkedList<Address> cloned = new LinkedList<Address>();
        for (Address address : addresses) {
            cloned.add(address != null ? address.clone() : null);
        }
        return cloned;
    }

    public String streetAddress(boolean useCountry) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.street).append(' ').append(this.number);
        builder.append(", ").append(this.city);
        if (this.postalCode != null && !this.postalCode.isEmpty()) {
            builder.append(" ").append(this.postalCode);
        }
        if (useCountry && this.country != null && !this.country.isEmpty()) {
            builder.append(", ").append(this.country);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.formatted, address.formatted) && Objects.equals(this.country, address.country) && Objects.equals(this.city, address.city) && Objects.equals(this.street, address.street) && Objects.equals(this.number, address.number) && Objects.equals(this.apt, address.apt) && Objects.equals(this.floor, address.floor) && Objects.equals(this.entrance, address.entrance) && Objects.equals(this.comment, address.comment) && Objects.equals(this.latLng, address.latLng) && Objects.equals(this.approximate, address.approximate) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.onArrival, address.onArrival) && Objects.equals(this.externalIds, address.externalIds) && Objects.equals(this.properties, address.properties);
    }

    public int hashCode() {
        return Objects.hash(this.formatted, this.country, this.city, this.street, this.number, this.apt, this.floor, this.entrance, this.comment, this.latLng, this.approximate, this.countryCode, this.postalCode, this.onArrival, this.externalIds, this.properties);
    }

    public String toString() {
        return "Address{formatted='" + this.formatted + '\'' + ", country='" + this.country + '\'' + ", city='" + this.city + '\'' + ", street='" + this.street + '\'' + ", number='" + this.number + '\'' + ", apt='" + this.apt + '\'' + ", floor='" + this.floor + '\'' + ", entrance='" + this.entrance + '\'' + ", comment='" + this.comment + '\'' + ", latLng=" + this.latLng + ", approximate=" + this.approximate + ", countryCode='" + this.countryCode + '\'' + ", postalCode='" + this.postalCode + '\'' + ", onArrival='" + this.onArrival + '\'' + ", externalIds=" + this.externalIds + ", properties=" + this.properties + '}';
    }
}

