/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Blob
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String url;

    public Blob(String id, String url) {
        this.id = id;
        this.url = url;
    }

    public Blob() {
    }

    public Blob clone() {
        return new Blob(this.id, this.url);
    }

    public static Map<String, Blob> clone(Map<String, Blob> blobs) {
        if (blobs == null) {
            return null;
        }
        LinkedHashMap<String, Blob> cloned = new LinkedHashMap<String, Blob>(blobs.size());
        for (Map.Entry<String, Blob> entry : blobs.entrySet()) {
            String key = entry.getKey();
            Blob value = entry.getValue();
            cloned.put(key, value != null ? value.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blob blob = (Blob)o;
        return Objects.equals(this.id, blob.id) && Objects.equals(this.url, blob.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url);
    }
}

