/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.openrest.v1_1.Variation;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String itemId;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<Variation> variations = new LinkedList<Variation>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<List<OrderItem>> variationsChoices = new LinkedList<List<OrderItem>>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String comment;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer price = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer count = 1;

    public OrderItem(String itemId, List<Variation> variations, List<List<OrderItem>> variationsChoices, String comment, Integer price, Integer count) {
        this.itemId = itemId;
        this.variations = variations;
        this.variationsChoices = variationsChoices;
        this.comment = comment;
        this.price = price;
        this.count = count;
    }

    public OrderItem() {
    }

    public OrderItem clone() {
        LinkedList<List<OrderItem>> clonedVariationsChoices;
        if (this.variationsChoices != null) {
            clonedVariationsChoices = new LinkedList<List<OrderItem>>();
            for (List<OrderItem> orderItems : this.variationsChoices) {
                clonedVariationsChoices.add(OrderItem.clone(orderItems));
            }
        } else {
            clonedVariationsChoices = null;
        }
        return new OrderItem(this.itemId, Variation.clone(this.variations), clonedVariationsChoices, this.comment, this.price, this.count);
    }

    public static List<OrderItem> clone(List<OrderItem> orderItems) {
        if (orderItems == null) {
            return null;
        }
        LinkedList<OrderItem> cloned = new LinkedList<OrderItem>();
        for (OrderItem orderItem : orderItems) {
            cloned.add(orderItem != null ? orderItem.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return Objects.equals(this.itemId, orderItem.itemId) && Objects.equals(this.variations, orderItem.variations) && Objects.equals(this.variationsChoices, orderItem.variationsChoices) && Objects.equals(this.comment, orderItem.comment) && Objects.equals(this.price, orderItem.price) && Objects.equals(this.count, orderItem.count);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.variations, this.variationsChoices, this.comment, this.price, this.count);
    }
}

