/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.openrest.v1_1.Address;
import com.openrest.v1_1.AppInfo;
import com.openrest.v1_1.Contact;
import com.openrest.v1_1.OpenrestObject;
import com.openrest.v1_1.Product;
import com.wix.restaurants.i18n.Locale;
import com.wix.restaurants.i18n.LocalizedString;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Organization
extends OpenrestObject
implements Cloneable,
Comparable<Organization> {
    private static final long serialVersionUID = 1L;
    public static final String MESSAGE_TYPE_WELCOME = "welcome";
    public static final String MESSAGE_TYPE_ORDER_CONFIRMATION = "order_confirmation";
    public static final String MESSAGE_TYPE_TERMS = "terms";
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String id;
    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String alias;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String affiliateId;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> externalIds = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Date created;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Date modified;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString title = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString description = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Contact contact;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address address;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String timezone;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String currency;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Locale locale;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Set<Locale> locales = new LinkedHashSet<Locale>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, LocalizedString> messages = new LinkedHashMap<String, LocalizedString>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<AppInfo> apps = new LinkedList<AppInfo>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> media = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean closed = Boolean.FALSE;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Set<Product> products = new LinkedHashSet<Product>();

    public Organization() {
    }

    protected Organization(String id, String alias, String affiliateId, Map<String, String> externalIds, Date created, Date modified, LocalizedString title, LocalizedString description, Locale locale, Set<Locale> locales, Map<String, LocalizedString> messages, Contact contact, Address address, String timezone, String currency, List<AppInfo> apps, Map<String, String> properties, Map<String, String> media, Boolean closed, Set<Product> products) {
        this.id = id;
        this.alias = alias;
        this.affiliateId = affiliateId;
        this.externalIds = externalIds;
        this.created = created;
        this.modified = modified;
        this.title = title;
        this.description = description;
        this.locale = locale;
        this.locales = locales;
        this.messages = messages;
        this.contact = contact;
        this.address = address;
        this.timezone = timezone;
        this.currency = currency;
        this.apps = apps;
        this.properties = properties;
        this.media = media;
        this.closed = closed;
        this.products = products;
    }

    public Organization clone() {
        return this.cloneImpl();
    }

    protected abstract Organization cloneImpl();

    protected static Map<String, LocalizedString> cloneMessages(Map<String, LocalizedString> messages) {
        if (messages == null) {
            return null;
        }
        LinkedHashMap<String, LocalizedString> cloned = new LinkedHashMap<String, LocalizedString>(messages.size());
        for (Map.Entry<String, LocalizedString> entry : messages.entrySet()) {
            cloned.put(entry.getKey(), entry.getValue() != null ? entry.getValue().clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization that = (Organization)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.alias, that.alias) && Objects.equals(this.affiliateId, that.affiliateId) && Objects.equals(this.externalIds, that.externalIds) && Objects.equals(this.created, that.created) && Objects.equals(this.modified, that.modified) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.contact, that.contact) && Objects.equals(this.address, that.address) && Objects.equals(this.timezone, that.timezone) && Objects.equals(this.currency, that.currency) && Objects.equals(this.locale, that.locale) && Objects.equals(this.locales, that.locales) && Objects.equals(this.messages, that.messages) && Objects.equals(this.apps, that.apps) && Objects.equals(this.properties, that.properties) && Objects.equals(this.media, that.media) && Objects.equals(this.closed, that.closed) && Objects.equals(this.products, that.products);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.alias, this.affiliateId, this.externalIds, this.created, this.modified, this.title, this.description, this.contact, this.address, this.timezone, this.currency, this.locale, this.locales, this.messages, this.apps, this.properties, this.media, this.closed, this.products);
    }

    @Override
    public int compareTo(Organization other) {
        return this.id.compareTo(other.id);
    }

    public String toString() {
        return "Organization{id='" + this.id + '\'' + ", alias='" + this.alias + '\'' + ", affiliateId='" + this.affiliateId + '\'' + ", externalIds=" + this.externalIds + ", created=" + this.created + ", modified=" + this.modified + ", title=" + this.title + ", description=" + this.description + ", contact=" + this.contact + ", address=" + this.address + ", timezone='" + this.timezone + '\'' + ", currency='" + this.currency + '\'' + ", locale=" + this.locale + ", locales=" + this.locales + ", messages=" + this.messages + ", apps=" + this.apps + ", properties=" + this.properties + ", media=" + this.media + ", closed=" + this.closed + ", products=" + this.products + '}';
    }
}

