/*
 * Decompiled with CFR 0.152.
 */
package com.presto.resources;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferClient;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public class SendFileToFtpServer {
    private String host;
    private String username;
    private String password;
    private String port;

    public SendFileToFtpServer(String host, String port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public String sendFile(String sfile, String flname) throws FTPException, IOException {
        FileTransferClient ftp = null;
        Logger log = Logger.getLogger(SendFileToFtpServer.class);
        Logger.setLevel(Level.INFO);
        log.info("Creating FTP client");
        ftp = new FileTransferClient();
        ftp.setRemoteHost(this.getHost());
        ftp.setRemotePort(Integer.valueOf(this.getPort()));
        ftp.setUserName(this.getUsername());
        ftp.setPassword(this.getPassword());
        ftp.setTimeout(10000);
        log.info("Connecting to server " + this.getHost());
        log.info("Connected and logged in to server " + this.getHost());
        log.info("sending : " + flname);
        ftp.getAdvancedFTPSettings().setConnectMode(FTPConnectMode.PASV);
        ftp.setContentType(FTPTransferType.BINARY);
        ftp.getAdvancedSettings().setControlEncoding("UTF-8");
        ftp.connect();
        String out = "";
        if (!ftp.isConnected()) {
            throw new FTPException("presto connection error : " + ftp.getLastReply().getReplyCode() + ":" + ftp.getLastReply().getReplyText() + ftp.getRemoteHost() + ":" + ftp.getRemotePort());
        }
        log.info("status of sending file: " + out);
        ftp.uploadFile(sfile, flname);
        out = ftp.getLastReply().getReplyCode();
        ftp.disconnect();
        return out;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

