/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.i18n;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.Serializable;
import java.util.Objects;

@JsonSerialize(using=ToStringSerializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Locale
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String languageTag;

    public Locale(String languageTag) {
        this.languageTag = Locale.toLanguageTag(languageTag);
    }

    public static Locale fromJavaLocale(java.util.Locale javaLocale) {
        return new Locale(javaLocale.toLanguageTag());
    }

    public Locale() {
    }

    public java.util.Locale toJavaLocale() {
        return java.util.Locale.forLanguageTag(this.languageTag);
    }

    public Locale clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Locale locale = (Locale)o;
        return Objects.equals(this.languageTag, locale.languageTag);
    }

    public int hashCode() {
        return Objects.hash(this.languageTag);
    }

    public String toString() {
        return Locale.toJavaLanguageTag(this.languageTag);
    }

    private static String toJavaLanguageTag(String languageTag) {
        return languageTag.replaceAll("-", "_");
    }

    private static String toLanguageTag(String javaLanguageTag) {
        return javaLanguageTag.replaceAll("_", "-");
    }
}

