/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.payments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wix.restaurants.payments.Payment;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BitpayPayment
extends Payment {
    public static final String TYPE = "com.bitpay";
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String token;

    public BitpayPayment() {
    }

    public BitpayPayment(Integer amount, Map<String, String> externalIds, String token) {
        super(amount, externalIds);
        this.token = token;
    }

    @Override
    public BitpayPayment clone() {
        return this.cloneImpl();
    }

    @Override
    protected BitpayPayment cloneImpl() {
        return new BitpayPayment(this.amount, this.externalIds != null ? new LinkedHashMap(this.externalIds) : null, this.token);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BitpayPayment that = (BitpayPayment)o;
        return Objects.equals(this.token, that.token);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.token);
    }
}

