/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import com.cav.mserver.Config;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientStatistics {
    private static Logger logger = Logger.getLogger((class$com$cav$mserver$ClientStatistics == null ? (class$com$cav$mserver$ClientStatistics = ClientStatistics.class$("com.cav.mserver.ClientStatistics")) : class$com$cav$mserver$ClientStatistics).getPackage().getName());
    private static ClientStatistics instance;
    private PrintStream statsStream;
    private InetAddress udpHost;
    private int udpPort;
    private DatagramSocket udpSocket = null;
    static /* synthetic */ Class class$com$cav$mserver$ClientStatistics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientStatistics instance() {
        if (instance == null) {
            Class clazz = class$com$cav$mserver$ClientStatistics == null ? (class$com$cav$mserver$ClientStatistics = ClientStatistics.class$("com.cav.mserver.ClientStatistics")) : class$com$cav$mserver$ClientStatistics;
            synchronized (clazz) {
                instance = new ClientStatistics();
            }
        }
        return instance;
    }

    private ClientStatistics() {
        String method = Config.getString("stats.method");
        if (method == null) {
            logger.info("Not keeping statistics");
            return;
        }
        if (method.equals("file")) {
            String statsFileName = Config.getString("stats.file.name");
            try {
                this.statsStream = new PrintStream(new FileOutputStream(statsFileName, true));
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Error opening stats file: " + statsFileName, e);
            }
            logger.info("Statistics to file: " + statsFileName);
        } else if (method.equals("udp")) {
            try {
                this.udpHost = InetAddress.getByName(Config.getString("stats.udp.host"));
            }
            catch (UnknownHostException e) {
                logger.log(Level.SEVERE, "Error getting host's address: " + Config.getString("stats.udp.host"), e);
            }
            try {
                this.udpPort = Integer.parseInt(Config.getString("stats.udp.port"));
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Error getting port number: " + Config.getString("stats.udp.port"), e);
            }
            try {
                this.udpSocket = new DatagramSocket();
            }
            catch (SocketException e) {
                logger.log(Level.SEVERE, "Error creating statistics socket", e);
            }
            logger.info("Statistics to server (UDP): " + this.udpHost + "/" + this.udpPort);
        } else {
            logger.warning("unknown statistics method: " + method);
        }
    }

    public void appendRecord(InetAddress clientAddress, String record) {
        record = this.formatRecord(clientAddress, record);
        if (this.statsStream != null) {
            this.statsStream.println(record);
        }
        if (this.udpSocket != null) {
            logger.info("sending: " + record);
            byte[] message = record.getBytes();
            DatagramPacket packet = new DatagramPacket(message, message.length, this.udpHost, this.udpPort);
            try {
                this.udpSocket.send(packet);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error sending statistics packet", e);
            }
        }
    }

    private String formatRecord(InetAddress clientAddress, String record) {
        int commaIndex = record.indexOf(44);
        long recordTime = System.currentTimeMillis();
        if (commaIndex > 0) {
            try {
                recordTime -= Long.parseLong(record.substring(0, commaIndex));
                record = record.substring(commaIndex + 1);
            }
            catch (NumberFormatException e) {
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        record = "" + recordTime + ',' + clientAddress.getHostAddress() + ',' + record;
        return record;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

