/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import com.cav.mserver.MumpsSession;
import com.cav.mserver.MumpsSessionPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MumpsServlet
extends HttpServlet {
    private static final String M_SESSION_CLEAR_CODE = "D CLEAR^%ZCAVJSP";
    private static final MessageFormat REMOTE_EXEC_M_ROUTINE = new MessageFormat("D REMEXEC^%ZCAVJSP(\"{0}\")");
    private static final Map EMPTY_ARGS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml");
        response.setCharacterEncoding("ISO-8859-1");
        response.setHeader("CACHE-CONTROL", "NO-CACHE");
        HashMap parameters = new HashMap(request.getParameterMap());
        String[] codeParam = (String[])parameters.remove("CODE");
        if (codeParam == null) {
            response.sendError(1, "No routine name given");
            return;
        }
        String code = codeParam[0];
        String label = REMOTE_EXEC_M_ROUTINE.format(new Object[]{code});
        MumpsSession mSession = null;
        try {
            int c;
            try {
                mSession = (MumpsSession)MumpsSessionPool.instance().borrowObject();
            }
            catch (Exception e) {
                response.sendError(2, "Error getting Mumps session " + e.toString());
                Object var12_10 = null;
                if (mSession == null) return;
                try {
                    MumpsSessionPool.instance().returnObject((Object)mSession);
                    return;
                }
                catch (Exception e2) {
                    response.sendError(3, "Error releasing Mumps session");
                    return;
                }
            }
            ServletOutputStream os = response.getOutputStream();
            os.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?><root>".getBytes());
            this.clearSession(mSession);
            InputStreamReader mumpsOutput = new InputStreamReader(mSession.execute(label, parameters), "ISO-8859-1");
            while ((c = mumpsOutput.read()) != -1) {
                if (c == 60) {
                    os.write("&lt;".getBytes());
                    continue;
                }
                if (c == 62) {
                    os.write("&gt;".getBytes());
                    continue;
                }
                if (c == 34) {
                    os.write("&quot;".getBytes());
                    continue;
                }
                if (c == 39) {
                    os.write("&apos;".getBytes());
                    continue;
                }
                if (c == 38) {
                    os.write("&amp;".getBytes());
                    continue;
                }
                os.write(c);
            }
            os.write("</root>".getBytes());
            this.clearSession(mSession);
            Object var12_11 = null;
            if (mSession == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (mSession == null) throw throwable;
            try {
                MumpsSessionPool.instance().returnObject((Object)mSession);
                throw throwable;
            }
            catch (Exception e2) {
                response.sendError(3, "Error releasing Mumps session");
                return;
            }
        }
        try {
            MumpsSessionPool.instance().returnObject((Object)mSession);
            return;
        }
        catch (Exception e2) {
            response.sendError(3, "Error releasing Mumps session");
            return;
        }
    }

    private void clearSession(MumpsSession mSession) {
        InputStream mumpsOutput = mSession.execute(M_SESSION_CLEAR_CODE, EMPTY_ARGS);
        try {
            while (mumpsOutput.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

