/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import com.cav.mserver.ClientStatistics;
import com.cav.mserver.Config;
import com.cav.mserver.LoggingConfiguration;
import com.cav.mserver.MumpsSession;
import com.cav.mserver.MumpsSessionPool;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MumpsTCPServer {
    private static Logger logger = Logger.getLogger((class$com$cav$mserver$MumpsTCPServer == null ? (class$com$cav$mserver$MumpsTCPServer = MumpsTCPServer.class$("com.cav.mserver.MumpsTCPServer")) : class$com$cav$mserver$MumpsTCPServer).getPackage().getName());
    private static final String MUMPS_CODE_ARG = "RTN";
    private static final String CLIENT_STATS_ARG = "%stats";
    private static final String MUMPS_DEFAULT_CODE = "D ^JPOS";
    private static final byte[] PROMPT_BYTES = "~~~> \n".getBytes();
    private static final String VERSION = "v1.2";
    static /* synthetic */ Class class$com$cav$mserver$MumpsTCPServer;

    public static void main(String[] args) {
        LoggingConfiguration.init();
        logger.info("Mumps Proxy Server v1.2");
        MumpsSessionPool.instance();
        ServerSocket serverSocket = null;
        String portStr = Config.getString("server.port");
        int port = 4444;
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not listen on port: " + port, e);
            System.exit(1);
        }
        while (true) {
            Socket clientSocket = null;
            try {
                clientSocket = serverSocket.accept();
                clientSocket.setTcpNoDelay(true);
                new ClientThread(clientSocket).start();
                continue;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Accept failed", e);
                System.exit(1);
                continue;
            }
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClientThread
    extends Thread {
        private Socket socket;

        public ClientThread(Socket socket) {
            this.socket = socket;
            logger.info("Client connected: " + socket.getInetAddress() + ',' + socket.getPort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block25: {
                OutputStream os = this.socket.getOutputStream();
                BufferedOutputStream out = new BufferedOutputStream(os, 1000);
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "ISO-8859-8"));
                String line = null;
                HashMap<String, String> params = new HashMap<String, String>();
                while ((line = in.readLine()) != null && !line.equalsIgnoreCase("quit") && !line.equalsIgnoreCase("q")) {
                    String stats;
                    block24: {
                        int c;
                        params.clear();
                        StringTokenizer tokenizer = new StringTokenizer(line, "&");
                        String mcode = MumpsTCPServer.MUMPS_DEFAULT_CODE;
                        stats = null;
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            int ind = token.indexOf(61);
                            if (ind == -1) continue;
                            String var = token.substring(0, ind);
                            String value = token.substring(ind + 1);
                            if (var.equals(MumpsTCPServer.MUMPS_CODE_ARG)) {
                                mcode = value;
                                continue;
                            }
                            if (var.equals(MumpsTCPServer.CLIENT_STATS_ARG)) {
                                stats = value;
                                continue;
                            }
                            params.put(var, "\"" + value + '\"');
                        }
                        MumpsSession mSession = null;
                        mSession = (MumpsSession)MumpsSessionPool.instance().borrowObject();
                        InputStream mumpsOutput = mSession.execute(mcode, params);
                        while ((c = mumpsOutput.read()) != -1) {
                            out.write(c);
                            if (c != 10) continue;
                            out.flush();
                        }
                        Object var14_17 = null;
                        try {
                            if (mSession != null) {
                                MumpsSessionPool.instance().returnObject((Object)mSession);
                            }
                            break block24;
                        }
                        catch (Exception e2) {
                            logger.log(Level.SEVERE, "Error returning Mumps session ", e2);
                        }
                        break block24;
                        {
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error borrowing Mumps session, or reading from it", e);
                                var14_17 = null;
                                try {
                                    if (mSession != null) {
                                        MumpsSessionPool.instance().returnObject((Object)mSession);
                                    }
                                    break block24;
                                }
                                catch (Exception e2) {
                                    logger.log(Level.SEVERE, "Error returning Mumps session ", e2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            var14_17 = null;
                            try {
                                if (mSession != null) {
                                    MumpsSessionPool.instance().returnObject((Object)mSession);
                                }
                            }
                            catch (Exception e2) {
                                logger.log(Level.SEVERE, "Error returning Mumps session ", e2);
                            }
                            throw throwable;
                        }
                    }
                    out.write(PROMPT_BYTES, 0, PROMPT_BYTES.length);
                    out.flush();
                    if (stats == null) continue;
                    ClientStatistics.instance().appendRecord(this.socket.getInetAddress(), stats);
                }
                Object var17_20 = null;
                logger.info("Client disconnected: " + this.socket.getInetAddress() + ',' + this.socket.getPort());
                try {
                    this.socket.close();
                }
                catch (IOException e3) {
                    logger.log(Level.WARNING, "Error closing socket", e3);
                }
                break block25;
                {
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Error in client thread", e);
                        Object var17_21 = null;
                        logger.info("Client disconnected: " + this.socket.getInetAddress() + ',' + this.socket.getPort());
                        try {
                            this.socket.close();
                        }
                        catch (IOException e3) {
                            logger.log(Level.WARNING, "Error closing socket", e3);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    logger.info("Client disconnected: " + this.socket.getInetAddress() + ',' + this.socket.getPort());
                    try {
                        this.socket.close();
                    }
                    catch (IOException e3) {
                        logger.log(Level.WARNING, "Error closing socket", e3);
                    }
                    throw throwable;
                }
            }
        }
    }
}

