/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver.tests;

import com.cav.mserver.tests.HttpMuxBenchmark;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;

public class MumpsTCPServerBenchmark
extends HttpMuxBenchmark {
    static /* synthetic */ Class class$com$cav$mserver$tests$HttpMuxBenchmark;

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: java " + (class$com$cav$mserver$tests$HttpMuxBenchmark == null ? (class$com$cav$mserver$tests$HttpMuxBenchmark = MumpsTCPServerBenchmark.class$("com.cav.mserver.tests.HttpMuxBenchmark")) : class$com$cav$mserver$tests$HttpMuxBenchmark).getName() + " host port num_threads num_requests");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int nThreads = Integer.parseInt(args[2]);
        int nRequests = Integer.parseInt(args[3]);
        for (int i = 0; i < nThreads; ++i) {
            new ClientThread(host, port, nRequests).start();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClientThread
    extends Thread {
        int nRequests;
        String host;
        int port;

        public ClientThread(String host, int port, int nRequests) {
            this.host = host;
            this.port = port;
            this.nRequests = nRequests;
        }

        public void run() {
            Socket socket = null;
            InputStream is = null;
            BufferedReader reader = null;
            PrintStream out = null;
            try {
                socket = new Socket(this.host, this.port);
                socket.setTcpNoDelay(true);
                is = socket.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is));
                out = new PrintStream(socket.getOutputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            long start = System.currentTimeMillis();
            long writes = 0L;
            long reads = 0L;
            for (int i = 0; i < this.nRequests; ++i) {
                try {
                    String line;
                    long before = System.currentTimeMillis();
                    out.println("RTN=D ^JPOS&TYPE=901");
                    out.flush();
                    writes += System.currentTimeMillis() - before;
                    before = System.currentTimeMillis();
                    while ((line = reader.readLine()) != null && !line.startsWith("~~~>")) {
                    }
                    reads += System.currentTimeMillis() - before;
                    continue;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
            }
            long duration = System.currentTimeMillis() - start;
            System.out.println("Took " + duration + " mSecs");
            System.out.println("Writes took " + writes + " mSecs");
            System.out.println("Reads took " + reads + " mSecs");
        }
    }

    protected static class MumpsConsoleInputStream
    extends InputStream {
        private int index = 0;
        private InputStream is;
        private final char[] prompt = new char[]{'~', '~', '~', '>', ' '};
        private boolean receivedPrompt = false;
        private int retransmit = -1;
        private int retransnitChar;

        public MumpsConsoleInputStream(InputStream is) {
            this.is = is;
        }

        public int available() throws IOException {
            if (this.receivedPrompt) {
                return 0;
            }
            return this.is.available();
        }

        public void close() throws IOException {
        }

        public boolean equals(Object obj) {
            return this.is.equals(obj);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        public void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            int c;
            if (this.receivedPrompt) {
                return -1;
            }
            if (this.retransmit > -1) {
                if (this.retransmit < this.index) {
                    return this.prompt[this.retransmit++];
                }
                if (this.retransmit == this.index) {
                    this.index = 0;
                    this.retransmit = -1;
                    return this.retransnitChar;
                }
            }
            while ((c = this.is.read()) == this.prompt[this.index]) {
                ++this.index;
                if (this.index != this.prompt.length) continue;
                this.receivedPrompt = true;
                return -1;
            }
            if (this.index > 0) {
                this.retransmit = 1;
                this.retransnitChar = c;
                return this.prompt[0];
            }
            return c;
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        public String toString() {
            return this.is.toString();
        }
    }
}

