/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.taglib.AttributeValidationException;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class PlotTypes {
    public static final String[] typeNames = new String[]{"xyarea", "xyline", "xyshapesandlines", "scatter", "xyverticalbar", "step", "candlestick", "highlow", "signal", "verticalbar", "area", "line", "shapesandlines"};
    private static final List typeList = Arrays.asList(typeNames);

    public static AbstractRenderer getRenderer(int idx) {
        switch (idx) {
            case 0: {
                return new XYAreaRenderer();
            }
            case 1: {
                return new StandardXYItemRenderer();
            }
            case 2: {
                return new StandardXYItemRenderer(3);
            }
            case 3: {
                return new StandardXYItemRenderer(1);
            }
            case 4: {
                return new XYBarRenderer();
            }
            case 5: {
                return new XYStepRenderer();
            }
            case 6: {
                return new CandlestickRenderer();
            }
            case 7: {
                return new HighLowRenderer();
            }
            case 9: {
                return new BarRenderer();
            }
            case 10: {
                return new AreaRenderer();
            }
            case 11: {
                return new LineAndShapeRenderer(true, false);
            }
            case 12: {
                return new LineAndShapeRenderer(true, true);
            }
        }
        throw new RuntimeException("Invalid renderer index:" + idx);
    }

    private PlotTypes() {
    }

    public static int getRendererIndex(String plotType) throws AttributeValidationException {
        int rendererIndex = typeList.indexOf(plotType.toLowerCase());
        if (rendererIndex < 0) {
            throw new AttributeValidationException("plot.type", plotType);
        }
        return rendererIndex;
    }
}

