/*
 * Created on 27/07/2005
 */
package com.cav.mapplet;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import com.cav.mserver.Config;

/**
 * Connector between web pages and mumps server.
 * the connection is done in the following way:
 * javascript <--> applet <--> servlet <--> mux
 * Using a javascript function to pass parameters to this
 * applet, mumps code can be executed from client events.
 * @author yishai, Cav Systems Ltd.
 */
public class MApplet extends Applet {

	/** The M server servlet path */
	private static final String PATH_TO_WEB_MSERVER = "mserver";

	/** Whether we should convert Hebrew to Unicode */
	public static boolean convertHebrewToUnicode;

	/* (non-Javadoc)
	 * @see java.applet.Applet#init()
	 */
	public void init() {
		convertHebrewToUnicode = "true"
				.equalsIgnoreCase(getParameter("convertHebrew"));
	}

	/**
	 * Execute code on mumps server. Use a servlet on the
	 * same server and port from which this applet has been loaded.
	 * @param mCodeKey encoded code to execute
	 * @param params the paramters to set in the M env prior to executing the code
	 * @return result of code execution
	 */
	public String mExecute(String mCodeKey, String params) {
		try {

			// get host and port from this applet's context
			String proxyHost = getDocumentBase().getHost();
			int port = getDocumentBase().getPort();
			// path to the mumps executing servlet on this server
			String[] path = getDocumentBase().getPath().split("\\/");
			String file = "/" + (path.length > 1 ? (path[1] + "/") : "")
							+ PATH_TO_WEB_MSERVER;
			System.out.println("file=" + file);
			// parameters to the servlet are session id, code to execute
			file += "?CODE=" + urlize(mCodeKey);
			// and a string with a map of all values of fields in the calling document
			file += "&ARGS=" + urlize(params);
			file = unicodeToASCIIHebrew(file);
			URL url = new URL(getDocumentBase().getProtocol(), proxyHost, port,
					file);
			System.out.println("Loading URL " + url);
			// execute the code and read the response
			StringBuffer sb = new StringBuffer();
			InputStream inputStream = url.openStream();
			int nextByte;
			while ((nextByte = inputStream.read()) != -1) {
				sb.append((char)nextByte);
			}
			return asciiToUnicodeHebrew(sb.toString());
		} catch (IOException e) {
			return "Cannot connect to proxy: " + e.getMessage();
		}
	}

	/**
	 * make a string url-compatible
	 * @param s the string to convert
	 * @return the url-compatible version of the string 
	 */
	static String urlize(String s) {
		StringBuffer rv = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (!Character.isLetterOrDigit(c) && c != '/')
				rv.append("%" + Integer.toString(c, 16));
			else
				rv.append(c);
		}
		return rv.toString();
	}

	/**
	 * Convert each ASCII Hebrew character in a string, Unicode
	 * @param text
	 * @return
	 */
	private static String asciiToUnicodeHebrew(String text) {
		if (convertHebrewToUnicode) {
			// Convert
			StringBuffer sbuf = new StringBuffer(text.length());
			for (int i = 0; i < text.length(); i++) {
				int c = text.charAt(i);
				if (c > 223 && c < 256) {
					c += 1264;
				}
				sbuf.append((char)c);
			}
			return sbuf.toString();
		}
		return text;
	}

	/**
	 * Convert each Unicode Hebrew character in a string, to 7-bit OLDCODE
	 * (Alef character is located at 96). 
	 * @param text
	 * @return
	 */
	private String unicodeToASCIIHebrew(String text) {
		if (convertHebrewToUnicode) {
			// Convert
	        StringBuffer sbuf = new StringBuffer(text.length());
	        for (int i = 0; i < text.length(); i++) {
	            int c = text.charAt(i);
	            if (c > 1487 && c < 1521) {
	            	c -= 1392;
	            }
	            if (c > 223 &&  c < 256) {
	            	c -= 128;
	            }
	            sbuf.append((char)c);
	        }
	        return sbuf.toString();
        }
		return text;
	}

}