package com.cav.mserver;

import java.io.*;

import javax.servlet.ServletException;
import javax.servlet.http.*;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

/**
 * A servlet which reports the status of the MUMPS session pool.
 * 
 * @author Uri Schor
 */
public class MumpsSessionPoolStatusServlet extends HttpServlet {

	/**
	 * Create a new Mumps servlet
	 */
	public MumpsSessionPoolStatusServlet() {
		super();
	}

	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/xml");
		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("CACHE-CONTROL", "NO-CACHE");
		OutputStream os = response.getOutputStream();
		os.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<root>\n"
				.getBytes());
		ObjectPool pool = MumpsSessionPool.instance();
		
		StringBuffer status = new StringBuffer("\t<Idle>");
		status.append(pool.getNumIdle());
		status.append("</Idle>\n");
		
		status.append("\t<Active>");
		status.append(pool.getNumActive());
		status.append("</Active>\n");

		if (pool instanceof GenericObjectPool) {
			GenericObjectPool genericPool = (GenericObjectPool)pool;
			status.append("\t<MaxActive>");
			status.append(genericPool.getMaxActive());
			status.append("</MaxActive>\n");
			
			status.append("\t<MaxIdle>");
			status.append(genericPool.getMaxIdle());
			status.append("</MaxIdle>\n");
			
			status.append("\t<MaxWaitMillis>");
			status.append(genericPool.getMaxWait());
			status.append("</MaxWaitMillis>\n");			
		}
		os.write(status.toString().getBytes());
		
		os.write("</root>".getBytes());
	}

}