package com.cav.mserver;


/**
 * Registry of Mumps types.
 * @author Uri Schor
 */
public class MumpsTypes {

	/** Unmapped type */
	public static final int OTHER = 0;
	
	/** Numeric type */
	public static final int NUMBER = 1;
	
	/** Integral numeric type */	
	public static final int INTEGER = 2;
	
	/** String type (normal, i.e. left justified */
	public static final int STRING = 3;
	
	/** Hebrew string, that should be right justified */
	public static final int HEB_STRING = 4;
	
	/** Date type */
	public static final int DATE = 5;

	/**
	 * Get the registered Mumps type.
	 * @param type The type descriptor
	 * @return A type constant
	 */
	public static int get(String type) {
		switch (type.charAt(0)) {
			case 'N' : return INTEGER;
			case 'S' : return NUMBER;
			case 'E' : return STRING;
			case 'H' : return HEB_STRING;
			case 'D' : return DATE;
			default : return OTHER;
		}
	}
}