package com.cav.mserver;

import java.util.logging.Logger;

import org.apache.commons.pool.BasePoolableObjectFactory;

/**
 * A poolable Mumps session factory.
 * 
 * @author Uri Schor
 */
public class PoolableMumpsSessionFactory extends BasePoolableObjectFactory {

	private static Logger logger = Logger
			.getLogger(PoolableMumpsSessionFactory.class.getPackage().getName());

	/** The class of the Mumps session to create in the factory */
	private Class mumpsSessionClass;

	/**
	 * Create a new factory.
	 * @param mumpsSessionClass The Mumps session class to instantiate.
	 */
	public PoolableMumpsSessionFactory(Class mumpsSessionClass) {
		this.mumpsSessionClass = mumpsSessionClass;
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.pool.PoolableObjectFactory#destroyObject(java.lang.Object)
	 */
	public void destroyObject(Object obj) throws Exception {
		logger.info("Destroy session");
		((MumpsSession)obj).close();
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.pool.PoolableObjectFactory#makeObject()
	 */
	public Object makeObject() throws Exception {
		logger.info("Create session");
		return mumpsSessionClass.newInstance();
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.pool.BasePoolableObjectFactory#validateObject(java.lang.Object)
	 */
	public boolean validateObject(Object obj) {
		boolean valid = ((MumpsSession)obj).validate();
		logger.info("Session validated: " + valid);
		return valid;
	}
}