package com.cav.mserver.tests;

import java.io.*;
import java.net.*;

/**
 * Benchmark HTTP Mumps wrappers (Well, actualy every URL-accessible wrapper),
 * by running a given number of concurrent client threads, each making a given 
 * number of URL loads in tight loop.
 * this test is, of course, not related to Mumps at all (besides its name :) ).
 * 
 * @author Uri Schor
 */
public class HttpMuxBenchmark {

	private static class ClientThread extends Thread {
		int nRequests;

		String serverUrl;

		public ClientThread(String serverUrl, int nRequests) {
			this.serverUrl = serverUrl;
			this.nRequests = nRequests;
		}
		
		/* (non-Javadoc)
		 * @see java.lang.Thread#run()
		 */
		public void run() {
			URL url = null;
			try {
				url = new URL(serverUrl);
			}
			catch (MalformedURLException e) {
				e.printStackTrace();
				return;
			}
			//StringBuffer sbuf = new StringBuffer();
			long start = System.currentTimeMillis();
			for (int i = 0; i < nRequests; ++i) {
				//sbuf.setLength(0);
				try {
					InputStream is = url.openConnection().getInputStream();
					//int c;
					while (is.read() != -1) {
						//sbuf.append((char)c);
					}
					is.close();
				}
				catch (IOException e1) {
					e1.printStackTrace();
					return;
				}
				//System.out.println("Got " + sbuf);
			}
			long duration = System.currentTimeMillis() - start;
			System.out.println("Took " + duration + " mSecs");
		}
	}

	public static void main(String[] args) {
		if (args.length != 3) {
			System.err.println("Usage: java "
								+ HttpMuxBenchmark.class.getName()
								+ " url num_threads num_requests");
			System.exit(1);
		}

		String serverUrl = args[0];
		int nThreads = Integer.parseInt(args[1]);
		int nRequests = Integer.parseInt(args[2]);
		for (int i = 0; i < nThreads; ++i) {
			new ClientThread(serverUrl, nRequests).start();
		}
	}

}