package com.cav.taglibs.mumps;

import java.util.*;
import java.util.logging.Logger;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

import com.cav.mserver.MumpsQuery;

/**
 * A tag that iterates a Mumps query result, row by row.
 * 
 * @author uri
 */
public class MumpsForeachColumnTag extends TagSupport {

	private static Logger logger = Logger.getLogger(MumpsForeachColumnTag.class
			.getPackage().getName());

	private Iterator colNameIter;

	private Iterator colTypeIter;

	String colName;

	Integer colType;

	public MumpsForeachColumnTag() {
	}

	/**
	 * @return Returns the current column name (or null, if none).
	 */
	public String getColName() {
		return colName;
	}

	/**
	 * @return Returns the current column type (or null, if none).
	 */
	public Integer getColType() {
		return colType;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		MumpsQueryTag queryTag = (MumpsQueryTag)findAncestorWithClass(
			this,
			MumpsQueryTag.class);
		if (queryTag == null) {
			throw new JspTagException(
					"A foreachCol tag must be nested within a query tag.");
		}
		MumpsQuery query = queryTag.getQuery();
		colNameIter = query.getColumnTitles().iterator();
		colTypeIter = query.getColumnTypes().iterator();
		if (colNameIter.hasNext()) {
			colName = (String)colNameIter.next();
			colType = (Integer)colTypeIter.next();
			return EVAL_BODY_AGAIN;
		}
		// else - no more rows
		return SKIP_BODY;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doAfterBody()
	 */
	public int doAfterBody() throws JspException {
		if (colNameIter.hasNext()) {
			colName = (String)colNameIter.next();
			colType = (Integer)colTypeIter.next();
			return EVAL_BODY_AGAIN;
		}
		// else - no more rows
		return SKIP_BODY;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doEndTag() throws JspException {
		// We have to call release() explicitly, since it doesn't have to be 
		// called by the container each time, according to the spec
		release();
		return EVAL_PAGE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#setPageContext(javax.servlet.jsp.PageContext)
	 */
	public void setPageContext(PageContext pageContext) {
		super.setPageContext(pageContext);
		this.pageContext = pageContext;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#release()
	 */
	public void release() {
		colNameIter = null;
		colTypeIter = null;
		colName = null;
		colType = null;
	}
}