package com.cav.taglibs.mumps;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag to check the thruth value of an M expression and execute the body tag
 * iff the expression evaluates to true.
 * @author uri
 */
public class MumpsIfTag extends TagSupport {

	private String expr;

	public MumpsIfTag() {
	}

	/**
	 * @return Returns the varName.
	 */
	public String getExpr() {
		return expr;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setExpr(String varName) {
		this.expr = varName;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"An if tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		boolean result = session.check(expr);
		if (result) {
			return EVAL_BODY_INCLUDE;
		}
		return SKIP_BODY;
	}
}