package com.cav.taglibs.mumps;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag that prints an M expression
 * @author uri
 */
public class MumpsOutTag extends TagSupport {

	private String expr;

	public MumpsOutTag() {
	}

	/**
	 * @return Returns the varName.
	 */
	public String getExpr() {
		return expr;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setExpr(String varName) {
		this.expr = varName;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"An out tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		String value = session.get(expr);
		try {
			pageContext.getOut().print(value);
		} catch (Exception ex) {
			throw new JspException("IO problems");
		}
		return SKIP_BODY;
	}
}