/*
 * Created on 21/04/2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.cav.taglibs.mumps;

import java.io.*;
import java.text.MessageFormat;
import java.util.*;
import java.util.logging.*;

import javax.servlet.ServletRequest;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import com.cav.mserver.Config;

/**
 * @author uri
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class MumpsSessionTag extends TagSupport implements TryCatchFinally {

	private static Logger logger = Logger.getLogger(MumpsSessionTag.class
			.getPackage().getName());

	/** The M namespace (AKA "UCI") that the session is in */
	private String namespace = "MGR";

	/** The M variable that HTTP arguments are put into */
	private static final MessageFormat HTTP_M_ARG = new MessageFormat(
			"%ARG(\"{0}\")");

	/** The M variable that HTTP body is put into */
	private static final MessageFormat HTTP_BODY_ARG = new MessageFormat(
			"%BODY(\"{0}\")");

	/** The M session */
	private JSPMumpsSession session;

	/** 
	 * Whether this session is debugged, and M command and output should be
	 * writtner put as HTML comments
	 */
	private Boolean debug = Boolean.FALSE;

	public MumpsSessionTag() {

	}

	/**
	 * @return Returns the namespace.
	 */
	public String getNamespace() {
		return namespace;
	}

	/**
	 * @param namespace The namespace to set.
	 */
	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}

	/**
	 * @return Returns the session.
	 */
	public JSPMumpsSession getSession() {
		return session;
	}

	/**
	 * @return
	 */
	public Boolean getDebug() {
		return debug;
	}

	/**
	 * @param debug
	 */
	public void setDebug(Boolean debug) {
		this.debug = debug;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		release();
		//setResponseHeaders();
		
		ServletRequest request = pageContext.getRequest();
		Map requestParams = new HashMap();
		requestParams.put("%REM", JSPMumpsSession.toMString(request
				.getRemoteAddr()));
		// TODO: get HTTP_REFERER
		requestParams.put("%NAM", JSPMumpsSession.toMString(""));
		Iterator paramIter = request.getParameterMap().entrySet().iterator();
		while (paramIter.hasNext()) {
			Map.Entry param = (Map.Entry)paramIter.next();
			// put the argument in %ARG() array
			requestParams.put(HTTP_M_ARG
					.format(new Object[] { param.getKey() }), JSPMumpsSession
					.toMString(((String[])param.getValue())[0]));
		}
				
		// TODO: get HTTP_FORWARDED_FOR
		requestParams.put("%FORW", JSPMumpsSession.toMString(""));
		// TODO: get HOSTIP
		requestParams.put("%HTIP", JSPMumpsSession.toMString(request
				.getRemoteAddr()));
		requestParams.put("%RMAD", JSPMumpsSession.toMString(request
				.getRemoteAddr()));
		requestParams.put("%RMHT", JSPMumpsSession.toMString(request
				.getRemoteHost()));
		if (request instanceof HttpServletRequest) {
			Cookie[] cookies = ((HttpServletRequest)request).getCookies();
			if (cookies != null) {
				requestParams.put("%COOK", JSPMumpsSession
						.toMString((cookies.length > 0) ? cookies[0].getValue()
								: ""));
			} else {
				requestParams.put("%COOK", JSPMumpsSession.toMString(""));
			}
		} else {
			requestParams.put("%COOK", JSPMumpsSession.toMString(""));
		}
		// TODO: get HTTP_X_AVANTGO_DEVICEID
		requestParams.put("%PAID", JSPMumpsSession.toMString(""));

		// Create the JSP M session. If this session is debugged, pass the
		// page output to it, so it'll write the M I/O to.
		try {
			session = new JSPMumpsSession(debug.booleanValue() ? pageContext
					.getOut() : null);
		}
		catch (Exception e) {
			logger.log(Level.SEVERE, "Error creating session", e);
			return SKIP_BODY;
		}
		session.switchNamespace(getNamespace(), requestParams);
		// reload the user session ID
		MumpsSetSessionIdTag.reloadSessionId(session, pageContext);

		// Get the request body
		int bodyLine = 0;
		try {
			BufferedReader bodyReader = new BufferedReader(request.getReader());
			String line = null;
			while ((line = bodyReader.readLine()) != null) {
				++bodyLine;
				session.set(HTTP_BODY_ARG.format(new Object[] { new Integer(
						bodyLine) }), JSPMumpsSession.toMString(line));				
			}
		}
		catch (IOException e) {
			throw new JspTagException(
					"Error gentting request budy", e);
		}

		// Add the JavaScript library if the content 
		if (pageContext.getResponse().getContentType().toLowerCase()
				.startsWith("text/html")) {
			try {
				initJavaScript();
			}
			catch (IOException e) {
				throw new JspTagException(
						"Error generating needed tags for Javascript.", e);
			}
		}
		return EVAL_BODY_INCLUDE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doEndTag() throws JspException {
		// We have to call release() explicitly, since it doesn't have to be 
		// called by the container each time, according to the spec
		release();
		return EVAL_PAGE;
	}

	/**
	 * Init the HTTP headers.
	 */
	private void setResponseHeaders() {
		if (pageContext.getResponse() instanceof HttpServletResponse) {
			HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
			// Do what it takes to disable caching by any browser/proxy
			response.setDateHeader ("Expires", 0);
			response.setHeader("cache-control", "no-store");
			response.setHeader("pragma", "no-cache");
		}
		
	}
	/**
	 * Generate the general stuff on the page output (Applet and JavaSCript 
	 * library), that is needed for JavaScript M execution.
	 * @throws IOException
	 */
	private void initJavaScript() throws IOException {
		String servletPath = "";
		if (pageContext.getRequest() instanceof HttpServletRequest) {
			servletPath = ((HttpServletRequest)(pageContext.getRequest()))
					.getContextPath();
		}

		// prinnt the value of the JavaScript variable "convertHebrewToUnicode"
		pageContext.getOut().println(
				"<script language=\"javascript\" type=\"text/javascript\">");
		pageContext.getOut().print("\tvar convertHebrewToUnicode = ");
		pageContext.getOut().print(
				Config.getBoolean("m.oldcode_hebrew").booleanValue() ? 
						true : false);
		pageContext.getOut().println(";");
		pageContext.getOut().println("</script>");
		
		// Include the servlet client script
		pageContext.getOut().println(
			"<script language=\"javascript\" src=\"" + servletPath
	+ "/mapplet/script.js\"></script>");
//		pageContext
//				.getOut()
//				.println(
//					"<applet name=\"MApplet\" archive=\""
//		+ servletPath
//		+ "/mapplet/mapplet.jar\" "
//		+ "code=\"com.cav.mapplet.MApplet\" width=\"0\" MAYSCRIPT "
//		+ "height=\"0\" align=\"right\">"
//		+ (Config.getBoolean("m.oldcode_hebrew").booleanValue() ? "<param name=\"convertHebrew\" value=\"true\"/>"
//				: "") + "</applet>");
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#setPageContext(javax.servlet.jsp.PageContext)
	 */
	public void setPageContext(PageContext pageContext) {
		super.setPageContext(pageContext);
		this.pageContext = pageContext;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#release()
	 */
	public void release() {
		super.release();
		if (session != null) {
			logger.fine("Releasing session");
			session.close();
			session = null;
		} else {
			logger.fine("No session to release");
		}
	}

	public void doCatch(Throwable ex) throws Throwable {
		logger.log(Level.SEVERE, "Caught exception. Releasing session", ex);
		release();
		
		// Try to print the exception to the page output
		pageContext.getOut().println();
		pageContext.getOut().println("<pre>");
		pageContext.getOut().print("Exception occured inside m:session tag: ");
		pageContext.getOut().println(ex.toString());
		StringWriter stackTrace = new StringWriter();
		ex.printStackTrace(new PrintWriter(stackTrace));
		pageContext.getOut().print(stackTrace.toString());
		pageContext.getOut().println("</pre>");
		pageContext.getOut().flush();
		
		pageContext.handlePageException(ex);
	}

	public void doFinally() {
		logger.fine("Finally called. Releasing session");
		release();
	}
}