/*
 * Created on 23/06/2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.cav.taglibs.mumps;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag to set the session ID in a variable that will be automatically
 * set for each page in the session.
 * @author uri
 */
public class MumpsSetSessionIdTag extends TagSupport {

	/** The name of the JSP variable that will hold the session ID */
	private static final String JSP_VAR_NAME = "_sessid";
	
	/** The name of the M variable that will hold the session ID */
	private static final String M_VAR_NAME = "JB";

	/** Code to run at the beginning of a session, to init the env */
	private static final String M_SESSION_INIT_CODE = "D INIT^%ZCAVJSP";

	private String expr;

	public MumpsSetSessionIdTag() {
	}

	public String getExpr() {
		return expr;
	}

	public void setExpr(String sessionId) {
		this.expr = sessionId;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"A set tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		String sessionId = session.get(getExpr());
		pageContext.getSession().setAttribute(JSP_VAR_NAME, sessionId);
		session.set(M_VAR_NAME, JSPMumpsSession.toMString(sessionId));
		session.exec(M_SESSION_INIT_CODE);
		return SKIP_BODY;
	}

	public static void reloadSessionId(
		JSPMumpsSession session,
		PageContext pageContext) {
		String sessionId = (String)pageContext.getSession().getAttribute(
			JSP_VAR_NAME);
		if (sessionId != null) {
			session.set(M_VAR_NAME, JSPMumpsSession.toMString(sessionId));
			session.exec(M_SESSION_INIT_CODE);
		}
	}
}