package com.cav.taglibs.mumps;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag to set and M variable
 * @author uri
 */
public class MumpsSetTag extends TagSupport {

	private String varName;

	private String varValue;

	public MumpsSetTag() {
	}

	/**
	 * @return Returns the varName.
	 */
	public String getVarName() {
		return varName;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setVarName(String varName) {
		this.varName = varName;
	}

	/**
	 * @return Returns the value.
	 */
	public String getVarValue() {
		return varValue;
	}

	/**
	 * @param value The value to set.
	 */
	public void setVarValue(String value) {
		this.varValue = value;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"A set tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		session.set(varName, varValue);
		return SKIP_BODY;
	}
}