package com.cav.taglibs.mumps;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag to check the thruth value of an M expression and execute the body tag
 * iff the expression evaluates to true.
 * @author uri
 */
public class MumpsWhileTag extends TagSupport {

	private String expr;

	private JSPMumpsSession session;
	
	public MumpsWhileTag() {
	}

	/**
	 * @return Returns the varName.
	 */
	public String getExpr() {
		return expr;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setExpr(String varName) {
		this.expr = varName;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doAfterBody()
	 */
	public int doAfterBody() throws JspException {
		return iterate();
	}
	
	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"An if tag must be nested within a session tag.");
		}
		session = sessionTag.getSession();
		return iterate();
	}
	
	private int iterate() {
		boolean result = session.check(expr);
		if (result) {
			return EVAL_BODY_AGAIN;
		}
		return SKIP_BODY;		
	}
	
	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#release()
	 */
	public void release() {
		session = null;
		expr = null;
	}
}