/*
 * Created on 05/06/2008
 */
package com.cav.taglibs.mumps.cewolf;

import java.util.Map;
import java.util.logging.*;

import org.jfree.data.category.*;
import org.jfree.util.TableOrder;

import de.laures.cewolf.DatasetProduceException;

/**
 * A Cewolf data producer for pie charts, which gets data from ZJ.
 * 
 * @author Uri Schor
 */
public class MumpsPieChartCewolfDataProducer extends MumpsChartCewolfDataProducer {

	/**
	 * Static initialization of the logger for this class
	 */
	private static Logger logger = Logger
			.getLogger(MumpsChartCewolfDataProducer.class.getPackage().getName());

	/**
	 * 
	 */
	public MumpsPieChartCewolfDataProducer() {
		super();
		logger.info("ZJPieChartCewolfDataProducer Created");
	}

	/* (non-Javadoc)
	 * @see com.cav.taglibs.mumps.cewolf.MumpsChartCewolfDataProducer#produceDataset(java.util.Map)
	 */
	public Object produceDataset(Map params) throws DatasetProduceException {
		CategoryDataset dataset = (CategoryDataset) super
				.produceDataset(params);
		
		// get the column number
		int columnNumber = 0;
		try {
			Integer col = (Integer) params.get("column");
			if (col == null) {
				logger
						.info("The column number is null - displaying first one.");
			}
			columnNumber = col.intValue();
		}
		catch (Exception e) {
			logger.log(Level.SEVERE, "Error getting column "
					+ "number - displaying first one.", e);
		}
		
		// return the data for the requested column
		return new CategoryToPieDataset(dataset, TableOrder.BY_COLUMN,
				columnNumber);
	}
}
