#!/bin/bash

# This is a backup utility that scan for all databases in uci.dat file
# and make a full backup by period defined in  "MAXINRCBACK" variable
# and incremenal backup rest of the time.
# Author  Dmitri Sandratsci
#DB env setted in /etc/env.d/40gtm
. /home/gtmuser/.appconfig
OK=0
FEXT=0
MAXINCRBACK=7
BACKDIR=backup
#gtmrepos="/usr/local/mumps/"
#export gtm_dist="/opt/gtm/"
MAILTO=damka76@yahoo.com
MAILCL="mail -n -s"

dblist()
{
	cat $gtmrepos/uci.dat |awk '{print $3}'|tr -d '\r'|sort|uniq
}

to_upper()
{
	
	res=`echo $1|tr a-z A-Z`
	echo $res
}

is_db_integ()
{
   dbname=$1
   
   if [ $dbname == "mumps" ];then
	int_dbname="DEFAULT"
   else
	int_dbname=$dbname		
   fi	

  int_dbname=`to_upper $int_dbname`

  $gtm_dist/mupip integ -reg "$int_dbname" #&> /tmp/${dbname}.integ
   status=$?
  # echo "in function status $status " 
   if [ $status -ne $OK ];then
   	$MAILCL "Integrity of $dbname log " $MAILTO < /tmp/$dbname.integ
   fi
   echo $status
}


dblist=$(dblist)

for dbname in $dblist
do
	if [ $dbname == "mumps" ];then
    		cd $gtmrepos
		export gtmgbldir=$gtmrepos/mumps.gld
		int_dbname="DEFAULT"
		backpath=$gtmrepos/$BACKDIR
	elif [ $dbname == "temp" ];then
		continue
	else	
		if [ ! -e $gtmrepos/${dbname} ];then
			continue
		fi
	
		int_dbname=`to_upper $dbname`
		
    		cd $gtmrepos/${dbname}
		export gtmgbldir=$gtmrepos/${dbname}/${dbname}.gld
		backpath=$gtmrepos/${dbname}/${BACKDIR}
	fi    
	$gtm_dist/mupip set -reg "$int_dbname" -journal="enable,before,sync_io,off"
	if [ ! -e $backpath ];then
		mkdir -p -m 766 $BACKDIR
	fi	
	#copy dbname.gld back dir 
	cp $gtmgbldir $backpath/	

	if [  -e $backpath/00${dbname}.dat ];then
		count=1
		FEXT=0

		for i in $(ls  $backpath/${dbname}_incr* 2> /dev/null )
            	do
              		count=$(expr $count + 1 ) 
            	done
		#echo "count is $count"

           	FEXT+=$count 

		integstatus=$(is_db_integ $dbname)
                #echo "integ status $integstatus  db $dbname "         

		if [ $integstatus  -ne $OK ];then 
		    continue
		fi

  		#incremental backup
        	$gtm_dist/mupip backup -bkupdbjnl=disable -bytestream -S=B "$int_dbname" $backpath #&> /tmp/${dbname}.out
		status=$?
		if [ $status -ne $OK ];then

		   # echo "backup incremental backup of $dbname  of status $status "  
		    $MAILCL "log of $dbname incremental backup status $status " "$MAILTO" < /tmp/${dbname}.out 
		fi
		if [ -e $backpath/${dbname}.dat ];then
			mv $backpath/${dbname}.dat $backpath/${dbname}_incr.$FEXT
		fi

		if [ $count -gt $MAXINCRBACK ];then
           		cd $backpath      
           		if [ -e ./backlast-1.tgz ];then
				
	        	       	/bin/rm ./backlast-1.tgz 
	        	       	/bin/rm ./backlast.tgz 
				 
	   		fi 
	   		tar --exclude *.tgz -zpPcf ./backlast.tgz  $(ls) 
           		if [ $? -eq 0  ];then
         			rm -f $backpath/${dbname}_incr*
                		rm -f $backpath/00*
           		fi
        	fi
	else
		integstatus=$(is_db_integ	$dbname)
		if [ $integstatus -ne 0 ];then 
		    continue
		fi
    
		#full backup
       		$gtm_dist/mupip backup -bkupdbjnl=disable -bytestream -transaction=1 "$int_dbname"  $backpath  #&> /tmp/${dbname}.out

		status=$?
		if [ $status -ne $OK ];then
		   # echo "full backup of $dbname  of status $status " &>> /tmp/${dbname}.out 
		    $MAILCL "log of $dbname  full backup status $status " "$MAILTO"  < /tmp/${dbname}.out 
		fi

		if [ -e $backpath/${dbname}.dat ];then
        		mv $backpath/${dbname}.dat $backpath/00${dbname}.dat
		fi
	fi
        echo "Please wait : reorging  DB !!!!"
        $gtm_dist/mupip reorg  2> /dev/null 
        echo "Reorg DB done"  
	#setting journal for DB
	$gtm_dist/mupip set -reg "$int_dbname" -journal="enable,before,sync_io,allocation=5000,extension=5000,epoch_interval=15"
     	if [ $dbname == "mumps" ];then
	####################### CLEAR OLD JOURNAL FILES OF MUMPS.DAT ##################
		fbackfl=${backpath}/00mumps.dat  
		if [ -e $fbackfl ];then
			for jnlfl in $gtmrepos/mumps.mjl_*
			do
				if [ $jnlfl -ot $fbackfl ];then
					#echo $jnlfl 
					/bin/rm -f $jnlfl
					
				fi
			done
		fi
	###############################################################################
	fi 
done		   
