

<html>
<!-- Copyright (c) 2005 Cav Systems Ltd.  All rights reserved. -->
<body bgcolor=white>
<%@ taglib uri="http://cav.co.il/taglibs/mumps" prefix="m" %>
<p>

This page demonstrates how to use the <b>serverExec</b> tag. We will execute M code, from JavaScript that is running on the browser, without reloading any page (WOW).
<br>
All of the form elements (text fields, checkboxes, choices, etc.) are passed
to the server as variable using their "name" attribute. It is therefore important
to assign a name to each of them.
<br>
<m:session namespace="USER">
<!-- Let us check if JB was passed in the URL, as argument -->
<!-- You should work in a session if you wish to interact between the JSP's M env. and the JavaScript's -->
<m:if expr='$D(%ARG("JB"))'>
        Session was passed as argument. Setting session ID to it<br>
        <m:setSessionId expr='%ARG("JB")'/>
</m:if>
<m:if expr="$D(JB)">
Inside a session...
</m:if>
<m:if expr="'$D(JB)">
Generating random session ID... <m:setSessionId expr="$R(1000)"/>
</m:if>
<br>
The session ID is set in M to: <b><m:out expr="JB"/></b>
<br>
<div>
<!-- IMPORTANT: All the form fields are passed to M as variables, with the form -->
<!-- field value assigned to. Therefore, each field must have a name attribute. -->

<!-- The following demonstrates how to get the output from M code. -->
<!-- Pay attention to the usage of quotes and double-quotes in the JavaScript code -->
<form method="get">Get The M time ($HOROLOG) <input type="button" value="press me" onClick='time.value=<m:serverExec expr="W $H"/>'/><input name="time"/>
</form>
</div>

<div>
<!-- The following demonstrates how to pass a value of JavaScript expression to M -->
<!-- The value passed here is the the value of the event target object (the button)-->
<form method="get">Get The value of the event target object <input type="button" name="press" value="press me" onClick='time.value=<m:serverExec expr="W VAL" varName="VAL" varValue="this.value"/>'/><input name="time"/>
</form>
</div>

<div>
<!-- In the following example the M code reffers to the "arg" variable from the form, which is passed automatically -->
<!-- Note that since the extra optional attribute "currentField" is passed, only the blurred field will be passed to the M server. -->
<!-- Use this option to make sure the requested URL is short. IExplorer has a limit of 2048 characters -->
<form method="get">Enter a number and exit the field, and M shall give you its square <input name="arg" value="1" onBlur='equals.value=<m:serverExec expr="D SQRTEST^%ZCAVJSP" currentField="true"/>'/>  <input name="equals"/>
</form>
</div>

<div>
<!-- The following demonstrates how the session ID (M variable "JB") is shared between JSP and JavaScript -->
<form method="get">Get The session ID of the JSP session <input type="button" name="try" value="try me" onClick='job.value=<m:serverExec expr="W JB"/>'/><input name="job"/>
</form>
</div>

</m:session>
<br>

</body>
</html>

