/*
 * JSGAutoOnTest.java
 *
 * Created on April 7, 2020, 11:17 PM
 */
package SecuGen.FDxSDKPro.samples;

import java.io.*;
import SecuGen.FDxSDKPro.jni.*;

/**
 *
 * @author  Dan Riley
 */
public class JSGAutoOnTest{

    /** Creates a new instance of JFPLibTest */
    public JSGAutoOnTest() {
    }

    ///////////////////////////////////////////////////////////////////////////
    //START AUTO ON
    // EnableAutoOnEvent(true)
    boolean StartAutoOn(JSGFPLib m_sgfplib)
    {
        long result;
        boolean StartAutoOn = false;
        ///////////////////////
        // Enable AutoOn Event
        System.out.println("Calling EnableAutoOnEvent(true) ... \n");  
        result = m_sgfplib.EnableAutoOnEvent(true);
        System.out.println("\treturned: " + result);  
        if (result == SGFDxErrorCode.SGFDX_ERROR_NONE)
            StartAutoOn = true;
        return StartAutoOn;
    }

    ///////////////////////////////////////////////////////////////////////////
    //STOP AUTO ON
    //EnableAutoOnEvent(false,NULL,NULL)
    boolean StopAutoOn(JSGFPLib m_sgfplib)
    {
        long result;
        boolean StopAutoOn = false;
        ///////////////////////
        // Disable AutoOn Event
        result = m_sgfplib.EnableAutoOnEvent(false);
        if (result == SGFDxErrorCode.SGFDX_ERROR_NONE)
            StopAutoOn = true;
        return StopAutoOn;
    }


    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // TODO code application logic here
        JSGAutoOnTest jsgAutoOnTest = new JSGAutoOnTest();
        jsgAutoOnTest.run();
    }

    public void run() {

        long err;
        byte kbBuffer[] = new byte[100];
        byte[] imageBuffer1;
        FileOutputStream fout = null;
        PrintStream fp = null;

        System.out.println("");
        System.out.println("###############################");
        System.out.println("SecuGen FDx SDK Pro for Java");
        System.out.println("Auto  Test Program");
        System.out.println("###############################");
        System.out.println("");
        
        ///////////////////////////////////////////////
        // Instantiate JSGFPLib object
        System.out.println("Instantiate JSGFPLib Object");
        JSGFPLib sgfplib = new JSGFPLib();
        if ((sgfplib != null) && (sgfplib.jniLoadStatus != SGFDxErrorCode.SGFDX_ERROR_JNI_DLLLOAD_FAILED))
        {
            System.out.println(sgfplib);
        }
        else
        {
            System.out.println("An error occurred while loading JSGFPLIB.DLL JNI Wrapper");
            return;
        }
        ///////////////////////////////////////////////
        // Init()
        System.out.println("Call Init(SGFDxDeviceName.SG_DEV_AUTO)");
        err = sgfplib.Init(SGFDxDeviceName.SG_DEV_AUTO);
        System.out.println("Init returned : [" + err + "]");

        ///////////////////////////////////////////////
        // OpenDevice()
        System.out.println("Call OpenDevice(SGPPPortAddr.AUTO_DETECT)");
        err = sgfplib.OpenDevice(SGPPPortAddr.AUTO_DETECT);
        System.out.println("OpenDevice returned : [" + err + "]");
		if (err != SGFDxErrorCode.SGFDX_ERROR_NONE)
			 System.out.println("OpenDevice: Failed : ErrorCode = " + err);
		else
		{
			///////////////////////////////////////////////
			// GetDeviceInfo()
			System.out.println("Call GetDeviceInfo()");
			SGDeviceInfoParam deviceInfo = new SGDeviceInfoParam();
			err = sgfplib.GetDeviceInfo(deviceInfo);
			if (err == SGFDxErrorCode.SGFDX_ERROR_NONE) {
				System.out.println( "GetDeviceInfo returned : [" + err + "]");
				System.out.println("\tdeviceInfo.DeviceSN:    [" + new String(deviceInfo.deviceSN()) + "]");
				System.out.println("\tdeviceInfo.Brightness:  [" + deviceInfo.brightness + "]");
				System.out.println("\tdeviceInfo.ComPort:     [" + deviceInfo.comPort + "]");
				System.out.println("\tdeviceInfo.ComSpeed:    [" + deviceInfo.comSpeed + "]");
				System.out.println("\tdeviceInfo.Contrast:    [" + deviceInfo.contrast + "]");
				System.out.println("\tdeviceInfo.DeviceID:    [" + deviceInfo.deviceID + "]");
				System.out.println("\tdeviceInfo.FWVersion:   [" + deviceInfo.FWVersion + "]");
				System.out.println("\tdeviceInfo.Gain:        [" + deviceInfo.gain + "]");
				System.out.println("\tdeviceInfo.ImageDPI:    [" + deviceInfo.imageDPI + "]");
				System.out.println("\tdeviceInfo.ImageHeight: [" + deviceInfo.imageHeight + "]");
				System.out.println("\tdeviceInfo.ImageWidth:  [" + deviceInfo.imageWidth + "]");
			}
			else
				 System.out.println("GetDeviceInfo: Failed : ErrorCode = " + err);

            ///////////////////////////////////////////////
            // Set Callback Function
            err = sgfplib.SetCallBackFunction(this);
            if (err != SGFDxErrorCode.SGFDX_ERROR_NONE)
            {
				 System.out.println("SetCallBackFunction: Failed : ErrorCode = " + err);
                return;
            }
            else
				 System.out.println("SetCallBackFunction: Success : ErrorCode = " + err);

            imageBuffer1 = new byte[deviceInfo.imageHeight*deviceInfo.imageWidth];


            if (StartAutoOn(sgfplib))
            {
//ZZ
                long n=0;//Visual feedback
                while (true)
                {
                    if (sgfplib.AutoOnEventOccurred())
                    {
                        n=0;//Reset visual feedback
                        System.out.println("Finger Present\n");
                        if (!StopAutoOn(sgfplib))
                        {
                            System.out.println("StopAutoOn() returned false.\n");
                            break;
                        }
                        System.out.println("Call ISensor::GetImage()\n");
                        err = sgfplib.GetImage(imageBuffer1);
                        System.out.println("ISensor::GetImage() returned ... ");
                        if (err != SGFDxErrorCode.SGFDX_ERROR_NONE)
                        {
                            System.out.println("FAIL - [" + err + "]");
                        }
                        else
                        {
                            System.out.println("SUCCESS - [" + err + "]");
                            //FILE *fp = fopen("test_auto_on_finger.raw","wb");
                            //fwrite (imageBuffer1 , sizeof (BYTE) , deviceInfo.ImageWidth*deviceInfo.ImageHeight , fp);
                            //fclose(fp);
                            //fp = NULL;
                        }
                        System.out.println(".............................................................\n");
                        System.out.println("Press 'X' to exit, any other key to continue >> ");
                        //if (getc(stdin) == 'X')
                        //    break;
                        try
                        {
                            System.in.read(kbBuffer);
                        }
                        catch (IOException e)
                        {
                            System.out.println("Exception reading keyboard : " + e);
                        }
                        if(kbBuffer[0] =='X')
                            break;
                        if(!StartAutoOn(sgfplib))
                        {
                            System.out.println("StartAutoOn() returned false.\n");
                            break;
                        }

                    }
                    else
                    {
                        ++n;//Visual feedback
                        System.out.println("place finger on sensor ... [" + n + "]");
                       try
                        {
                        Thread.sleep(100);
                        }
                        catch (Exception e)
                        {
                            System.out.println("Thread sleep exception : " + e);
                        }
                    }               
                }
//ZZ
            }

            //////////////////////////////////////////////////////////////////////////
            // EnableAutoOnEvent(false)
            System.out.println("Call EnableAutoOnEvent(false) ... \n");
            err = sgfplib.EnableAutoOnEvent(false);
            System.out.println("EnableAutoOnEvent(false) returned : [" + err + "]");

			///////////////////////////////////////////////
			// CloseDevice()
			System.out.println("Call CloseDevice()");
			err = sgfplib.CloseDevice();
			System.out.println("CloseDevice returned : [" + err + "]");
		}

        ///////////////////////////////////////////////
        // Close JSGFPLib native library
        System.out.println("Call Close()");
        sgfplib.Close();
        System.out.println("Close returned : [" + err + "]");

        sgfplib = null;
        imageBuffer1 = null;

    }    
}
